% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{calcularIndiceDificultad}
\alias{calcularIndiceDificultad}
\title{Índice de dificultad}
\usage{
calcularIndiceDificultad(respuestasCorregidas, proporcion = 0.5, digitos = 2)
}
\arguments{
\item{respuestasCorregidas}{Un data frame con los puntajes obtenidos por los estudiantes
en cada pregunta.}

\item{proporcion}{Proporción de estudiantes que forman parte de los grupos superior
e inferior. Valores habituales son 0.25, 0.27 y 0.33. Una proporción de 0.5 significa
que se toman todos los datos para calcular este índice.}

\item{digitos}{La cantidad de dígitos significativos que tendrá el resultado.}
}
\value{
Una vector con los índices de dificultad para cada ítem.
}
\description{
Calcula el índice de dificultad para cada ítem.
}
\details{
El índice de dificultad p corresponde a la proporción de estudiantes
de los grupos superior e inferior que responden correctamente el ítem.
Puede tomar valores entre 0 y 1. A mayor valor, el ítem es más fácil y viceversa.
}
\examples{
respuestas <- datos[,-1]
respuestasCorregidas <- corregirRespuestas(respuestas, clave)
p <- calcularIndiceDificultad(respuestasCorregidas)
item <- colnames(respuestas)
cbind(item, p)
}
\references{
Morales, P. (2009). Análisis de ítem en las pruebas objetivas.
Madrid. Recuperado de \url{https://educrea.cl/wp-content/uploads/2014/11/19-nov-analisis-de-items-en-las-pruebas-objetivas.pdf}
}
\seealso{
\code{\link{corregirRespuestas}}, \code{\link{datos}} y \code{\link{clave}}.
}
