% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery.R
\name{istat_dataset}
\alias{istat_dataset}
\title{Create an ISTAT dataset object}
\usage{
istat_dataset(dataflow_identifier)
}
\arguments{
\item{dataflow_identifier}{Either a dataflow ID (e.g., "139_176"),
a structure ID, or an exact dataset description}
}
\value{
A list with class "istat_dataset" containing:
\describe{
\item{df_id}{Dataflow ID}
\item{version}{Dataset version}
\item{df_description}{Dataset description}
\item{df_structure_id}{Data structure definition ID}
\item{dimensions}{Named list of dimension information}
\item{filters}{Named list of current filters (initialized to "." for all)}
}
}
\description{
Creates a dataset object for a specific ISTAT dataflow. This object can be used
to explore the dataset's structure, dimensions, and available values, and to
set filters before retrieving data.
}
\examples{
\dontrun{
# Create dataset by ID
ds <- istat_dataset("139_176")

# View dimensions
dimensions_info(ds)

# Get available values for a dimension
get_dimension_values(ds, "TIPO_DATO")

# Set filters
ds <- set_filters(ds, FREQ = "M", TIPO_DATO = c("ISAV", "ESAV"))
}
}
