% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_single_run.R
\name{plot_single_run}
\alias{plot_single_run}
\title{plot sim.single_run outputs}
\usage{
plot_single_run(
  workdir,
  RUN_ID,
  time_as_log10 = TRUE,
  time_unit = NULL,
  hidden_boxes = NULL,
  return_as_print = TRUE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{isobxr excel master file}}
and where output files will be stored if exported by user.
(character string)}

\item{RUN_ID}{ID of the run (formerly SERIES_RUN_ID).
Corresponds to the name of the .rds file storing the results of the run.}

\item{time_as_log10}{If TRUE, uses logarithmic time scale in plot. \cr
Default is TRUE.}

\item{time_unit}{Time unit to use on plot if different from native time unit. \cr
Character string, to be selected among the following: \cr
\emph{micros, ms, s, min, h, d, wk, mo, yr, kyr, Myr, Gyr} \cr
Default is NULL.}

\item{hidden_boxes}{List of boxes to hide from plots, as a vector of character strings. \cr
For instance c("SOURCE", "SINK").}

\item{return_as_print}{If TRUE, prints delta and size vs. time plots in a single page figure on R. \cr
If FALSE, returns separately delta and size vs. time plots as list of editable R objects. \cr
Default is TRUE.}
}
\value{
A set of plots showing the evolution of delta and sizes with time.
}
\description{
A function to plot delta and size vs time from the sim.single_run outputs
}
