% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equate_stuirt.R
\name{equate_stuirt}
\alias{equate_stuirt}
\title{IRT Scale Transformation using STUIRT Program}
\usage{
equate_stuirt(
  new_ip,
  ref_ip,
  method = c("stocking-lord", "haebara", "mean-mean", "mean-sigma"),
  common_item_ids = NULL,
  stuirt_exe_path = "C:/STUIRT/STUIRT.exe",
  target_dir = getwd(),
  analysis_name = "stuirt_analysis",
  add_options = TRUE,
  starting_values = c(1, 0),
  number_of_iterations = NULL,
  new_dist = NULL,
  ref_dist = NULL,
  fs = c("DO", "DO"),
  sy = c("BI", "BI"),
  lm = NULL,
  ko = "SL",
  show_output_on_console = TRUE
)
}
\arguments{
\item{new_ip}{An \code{\link{Itempool-class}} object holding the item
parameters of the new form.}

\item{ref_ip}{An \code{\link{Itempool-class}} object holding the item
parameters of the old form which is the reference form.}

\item{method}{A string specifying the method to use for equating the new item
parameters \code{new_ip} to the reference scale (\code{ref_ip}). Choose
from methods like \code{"stocking-lord", "haebara", "mean-mean",
"mean-sigma"}. The default method is \code{"stocking-lord"}.}

\item{common_item_ids}{The item IDs of the common items. The default is
\code{NULL}, assuming that all items are common. Ensure that the same
'item_id's are used in both 'new_ip' and 'ref_ip'.}

\item{stuirt_exe_path}{The path for the STUIRT executable "STUIRT.exe".
Example: \code{"C:/STUIRT/STUIRT.exe"}.}

\item{target_dir}{The directory/folder where the STUIRT analysis will be
saved. The default value is the current working directory, i.e.
\code{get_wd()}.}

\item{analysis_name}{A short file name for the data files created for the
analysis.}

\item{add_options}{A logical value. If \code{TRUE}, the keyword "OP" will be
added to the syntax. This option is useful for detailed program output.
Without \code{OP}, the section "OPTIONS AND DEFAULTS" will not appear in
the main output file.}

\item{starting_values}{A numeric vector of length two providing starting
values for the slope and intercept of the linear transformation in the
Haebara and Stocking-Lord methods. The default values are \code{c(1, 0)}
(i.e., slope = 1 and intercept = 0).}

\item{number_of_iterations}{An integer indicating the maximum number of
iterations to obtain transformation constants that minimize criterion
functions for the Haebara and Stocking-Lord methods. The default value is
\code{NULL}, which lets STUIRT use a maximum of 20 iterations.}

\item{new_dist}{A list specifying proficiency distribution
  of new group's distribution. The list should have three named elements:
  \describe{
    \item{"type"}{A string indication the type of the distribution. The
      following values can be used:
      \describe{
        \item{"GH"}{From STUIRT manual "Gauss-Hermite quadrature points and
        weights. This subkeyword can be used properly, if a continuous
        distribution of proficiency is known or estimated and the summation
        of the criterion function could be replaced by integration over the
        proficiency continuum. In the program, the proficiency distribution
        is assumed a standard normal one. The possible maximum number of
        quadrature points is 180. Although more than 180 quadrature points
        are theoretically possible, the author's experiences suggest that
        quadrature weights tend to be unstable when trying to obtain more
        than about 200 quadrature points. According to Zeng and Kolen (1994),
        even 80 quadrature points seem to be enough to estimate the slope and
        intercept of a linear transformation to a satisfactory degree."
        (p.12)}
        \item{"PN"}{From STUIRT manual: "PN stands for a polygonal
        approximation to a normal distribution. A polygonal approximation is
        often encountered in finding areas and evaluating integrals. PN can
        be used to evaluate n proficiency points and their weights to
        approximate a normal distribution having a value of mean and a value
        of std, with a left end point and a right end point being mean -
        multiple-of-std × std and mean + multiple-of-std × std, respectively.
        More specifically, n proficiency points are equally spaced over the
        range of a left end point to a right end point. At each proficiency
        point, the density from N(mean, std) is computed. All the densities
        are summed and then each density is divided by the sum so that the
        densities are standardized. The resulting values of densities are
        used as the weights. These steps are similar to those used in
        PC-BILOG (Mislevy & Bock, 1986)." (p.12)}
        \item{"PB"}{From STUIRT manual: "Third, PB stands for a polygonal
        approximation to a four-parameter beta distribution , where alpha and
        beta are two scale parameters and l and u are lower and upper limits.
        To evaluate n proficiency points and their weights, the same logic
        used in PN is applied except that the interval [l, u] is divided into
        n subintervals and then the midpoint of each subinterval is used for
        a proficiency point." (p.12)}
        \item{"RN"}{From STUIRT manual: "Fourth, RN stands for random numbers
        from a normal distribution. With two real numbers for a mean and a
        standard deviation, RN generates n pseudo-random proficiency values
        sampled from a normal distribution, N(mean, std)." (p.12)}
        \item{"RU"}{From STUIRT manual: "RU stands for random numbers from a
        uniform distribution. With two real numbers for a lower limit and an
        upper limit, RU generates n pseudo-random proficiency values ranging
        from lower-limit to upper-limit." (p.12)}
        \item{"ED"}{From STUIRT manual: "ED stands for equal distance in the
        intervals between two theta points on the proficiency scale. Users
        should supply two real numbers for a starting point and an ending
        point. The theta continuum ranging from the starting point to the
        ending point is divided into 1 - n intervals with an equal length."
        (p.12). In this function only "EQ" is available which means same
        constant weight of 1 is used. }
      }
    }
    \item{"n"}{An integer specifying the "the number of proficiency points
    and should be a number between 1 and 1000, inclusive" (p.11)}
    \item{"pars"}{A vector of numbers specifying the parameters used
    for each distribution. Based on the type of distribution following
    parameters should be specified.
    \describe{
      \item{GH}{No parameters is needed, it can be NULL}
      \item{PN}{mean, std, multiple-of-std}
      \item{PB}{alpha, beta, lower-limit, upper-limit}
      \item{RN}{mean, std}
      \item{RU}{lower-limit, upper-limit}
      \item{ED}{starting, ending}
    }
    }
  }

  The default is \code{NULL}. If so the STUIRT default will be used which is
  according to manual: "The default setting for proficiency values and their
  weights is that 25 proficiency values, which are equally spaced between
  -3.0 and 3.0, are used with the same weight 1.0 for all proficiency
  values." (p.13)

  Here are some examples for different distributions:
  \describe{
    \item{GH}{\code{list(type = "GH", n = 41, pars = NULL)}}
    \item{PN}{\code{list(type = "PN", n = 41, pars = c(0, 1, 4))}}
    \item{PB}{\code{list(type = "PB", n = 51, pars = c(2, 15, 0, 40))}}
    \item{RN}{\code{list(type = "RN", n = 31, pars = c(0, 1))}}
    \item{RU}{\code{list(type = "RU", n = 41, pars = c(0, 3))}}
    \item{ED}{\code{list(type = "ED", n = 25, pars = c(-3, 3))}}
  }}

\item{ref_dist}{A list representing the proficiency distribution
of the reference group. Refer to the description of the 'new_dist'
argument for more details.}

\item{fs}{A two-element string vector. Each element should be
  one of the following values: \code{"DO"} or \code{"NO"}.

  From the STUIRT manual: "The option keyword FS is used for standardizing
  the criterion functions for the Haebara and Stocking-Lord methods. The two
  subkeywords, DO and NO, are used to specify options. The first DO or NO is
  for the Haebara method and the second DO or NO is for the Stocking- Lord
  method. DO means that standardization is done and NO means that no
  standardization is done. What is meant by standardization of the criterion
  function is that one divides a sum of squared differences between
  characteristic curves in the criterion function by the number of the
  squared differences or the sum of weights assigned to the differences. For
  example, usually, to standardize the criterion function for the
  Stocking-Lord method, one divides the sum of squared differences between
  test characteristic curves by the number of proficiency values (or
  examinees). For more detailed information, refer to Kim and Lee (2004).
  Theoretically, the standardization of the criterion functions should not
  affect the solutions of the Haebara and Stocking-Lord methods. However, in
  practice, it could affect the solutions since the minimization algorithm
  used for nonlinear problems is affected by the magnitude of the criterion
  function due to its stopping rules. By default, standardization is
  conducted for both the Haebara and Stocking-Lord criterion functions."
  (p.13)

  If the value is \code{NULL} where this keyword is not added to the
  syntax and STUIRT will use it's default values.}

\item{sy}{A two-element string vector. Both of the elements should be
  one of the following values: \code{"BI"}, \code{"ON"} or \code{"NO"}.

  From the STUIRT manual: "The option keyword SY is used to define criterion
  functions as non-symmetric or symmetric. Three subkeywords, BI, NO, and ON,
  are used to specify options. The first BI, NO, or ON is for the Haebara
  method and the second BI, NO, or ON is for the Stocking-Lord method.
  Theoretically, the criterion function for either of the Haebara and
  Stocking-Lord methods could be defined in three symmetry-related ways. The
  first is one in which the criterion function is defined only on the old
  scale as in the typical use of the Stocking-Lord method (new-to-old
  direction: NO). The second is one in which the criterion function is
  defined only on the new scale (old-to-new direction: ON). The third is one
  in which the criterion function is defined on the both old and new scales
  as in the use of the Haebara method (new-to-old and old-to-new, i.e.,
  bi-directional: BI) Theoretically, the three ways, BI, NO, and ON, to
  define the criterion function in question should give the same solutions as
  far as sampling error and model misfit do not happen. However, with sample
  data, the three ways will give different solutions for scale
  transformation. The default setting is in such that SY BI BI." (p.14)

  If the value is \code{NULL} where this keyword is not added to the
  syntax and STUIRT will use it's default values.}

\item{lm}{A six element list with following elements:
  (1) slope, (2) intercept, (3) number-of-searches, (4) radius,
  (5) tolerance, and, (6) either "NO" or "IN".

  From the STUIRT manual: "The option keyword LM is used to search for
  possible local minimum solutions for the scale transformation constants
  after the first solutions for the Haebara and Stocking-Lord methods are
  obtained. Three subkeywords, NO, IN, and FI are prepared to instruct the
  program how and where to show the resulting history of local minimum
  search. If NO is used, no history is shown in an output file. If IN is
  used, the resulting history is shown within the main output file specified
  by users or opened by the program. If FI followed by a file name is used,
  the resulting history is saved separately in the file, which does not need
  to be located in the folder having the executable file of STUIRT." (p.14)

  If the value is \code{NULL} where this keyword is not added to the
  syntax and STUIRT will use it's default values.}

\item{ko}{A string that specify "input files for the program POLYEQUATE".
  Available values are \code{"MM"}, \code{"MS"}, \code{"HA"} and \code{"SL"}.

  From the STUIRT manual: "The four subkeywords, MM, MS, HA, and SL stand for
  the mean/mean, mean/sigma, Haebara, and Stocking-Lord methods,
  respectively. " (p.15)

  If the value is \code{NULL} where this keyword is not added to the
  syntax and STUIRT will use it's default values.}

\item{show_output_on_console}{logical (not NA), indicates whether to capture
the output of the command and show it on the R console. The default value
is \code{TRUE}.}
}
\description{
This function serves as an interface for the STUIRT program (Kim & Kolen,
2004) which offers a range of equating methods including mean-mean,
mean-sigma, Haebara, and Stocking-Lord. It is essential to have the
STUIRT program installed on your computer for this function to work.
You can download the program from the University of Iowa's Center for
Advanced Studies in Measurement and Assessment (CASMA) webpage:
\url{https://education.uiowa.edu/casma/computer-programs}
}
\examples{
\dontrun{

# ---------- Mixed Models ------------ #
n_item <- 30
models <- sample(c("3PL", "GPCM2"), n_item, TRUE)
new_ip <- generate_ip(model = models, D = 1.702)
old_ip_df <- data.frame(new_ip)
old_ip_df$a <- old_ip_df$a + round(runif(n_item, min = -.2, max = .2), 2)
old_ip_df$b <- old_ip_df$b + round(runif(n_item, min = -.2, max = .2), 2)
old_ip_df$d1 <- old_ip_df$d1 + round(runif(n_item, min = -.2, max = .2), 2)
old_ip_df$d2 <- old_ip_df$d2 + round(runif(n_item, min = -.2, max = .2), 2)
old_ip_df$d3 <- old_ip_df$d3 + round(runif(n_item, min = -.2, max = .2), 2)
ref_ip <- itempool(old_ip_df)

result <- equate_stuirt(new_ip = new_ip,
                        ref_ip = ref_ip,
                        target_dir = "C:/Temp/testthat-stuirt",
                        stuirt_exe_path = "C:/STUIRT/STUIRT.exe",
                        )
result

}

}
\references{
Kim, S., & Kolen, M. J. (2004). STUIRT [Computer software]. Iowa City,
IA: Iowa Testing Programs, The University of Iowa
}
\author{
Emre Gonulates
}
