% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoublyRobust.R
\name{KnownErrorDR}
\alias{KnownErrorDR}
\title{Doubly Robust Estimation of ATE with Known Error}
\usage{
KnownErrorDR(data, indA, indYerror, indXtrt, indXout, sensitivity, specificity,
  sharePara = FALSE, confidence = 0.95)
}
\arguments{
\item{data}{The dataset to be analyzed in the form of R data frame without missing data}

\item{indA}{A column name indicating the binary treatment variable}

\item{indYerror}{A column name indicating the misclassified binary outcome variable}

\item{indXtrt}{A vector of column names indicating the covariates included in the treatment model}

\item{indXout}{A vector of column names indicating the covariates included in the outcome model}

\item{sensitivity}{The specified sensitivity between 0 and 1}

\item{specificity}{The specified specificity between 0 and 1}

\item{sharePara}{if the treated and untreated groups share parameters for covariates in the logistic outcome model (i.e., assuming Y~ T+X), then set \code{sharePara=TRUE}; if not (i.e., modeling Y~ X for the treated and untreated groups separately), then set \code{sharePara=FALSE}. By default,  \code{sharePara=FALSE}}

\item{confidence}{The confidence level between 0 and 1; the default is 0.95 corresponding to a 95 per cent confidence interval}
}
\value{
A list of the estimate of average treatment effect, sandwich-variance-based standard error and confidence interval
}
\description{
Doubly robust estimation of average treatment effect with known outcome misclassification probabilities, i.e., known sensitivity and specificity
}
\examples{
#create a dataset with sensitivity=0.95 and specificity=0.85
set.seed(100)
X=rnorm(2000)   
xx=X^2
A=rbinom(2000,1,1/(1+exp(-0.1-X-0.2*xx)))
Y=rbinom(2000,1,1/(1+exp(1-A-0.5*X-xx)))
y1=which(Y==1)
y0=which(Y==0) 
Y[y1]=rbinom(length(y1),1,0.95)
Y[y0]=rbinom(length(y0),1,0.15)
Yast=Y
da=data.frame(A=A,X=X,xx=xx,Yast=Yast)
head(da)
#apply the doubly robust correction method with sensitivity=0.95 and specificity=0.85
KnownErrorDR(da,"A","Yast",c("X","xx"),c("X","xx"),0.95,0.85,FALSE,0.95)

}
