% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbeauti.R
\name{rbeauti}
\alias{rbeauti}
\title{XML Input Files for BEAST}
\usage{
rbeauti(
  ...,
  file,
  template = "standard",
  link.clocks = TRUE,
  link.trees = TRUE,
  subst.model,
  clock,
  tree,
  taxonset,
  chain.length = 1e+07,
  log.every = 1000
)
}
\arguments{
\item{...}{One or more object(s) of class \code{\link[ape]{DNAbin}}.}

\item{file}{A connection, or a character string naming the file to write to.
If left empty the XML tree will be printed to the screen (see Examples).}

\item{template}{\emph{Currently unused.}}

\item{link.clocks}{Logical, indicating if clock models should be linked over partitions.}

\item{link.trees}{Logical, indicating if tree models should be linked over partitions.}

\item{subst.model}{A character string defining a substituion model, either
\code{"JC69"}, \code{"HKY"},\code{"TN93"}, or \code{"GTR"}.}

\item{clock}{A character string defining a clock model, either \code{"Strict
Clock"}, \code{"Relaxed Clock Exponential"},\code{"Relaxed Clock Log
Normal"}, or \code{"Random Local Clock"}.}

\item{tree}{A character string defining a tree model.}

\item{taxonset}{A list containing one or more taxon sets.}

\item{chain.length}{Integer, the number of generations to run the MCMC.}

\item{log.every}{Integer, defining how often samples from the posterior will
be written to log files and shown on screen.}
}
\description{
Prepare XML files for BEAST with R. BEAST uses an MCMC approach
  to estimate rooted phylogenies from molecular data (Drummond & Rambaut,
  2007).
}
\details{
\code{rbeauti} has been completely rewritten to work with
  \bold{BEAST 2}. Currently \code{rbeauti} offers few options, because the
  idea is not to create ready-to-use XML file. That can be done conveniently
  with \bold{BEAUti} (the BEAST package's genuine XML generator). Instead,
  \code{rbeauti} is intended to make the definition of large numbers of taxon
  sets easy. The creation of taxon sets can be done via R scripts and the
  resulting XML files can be further modified with BEAUti.
}
\examples{
data(ips.16S)

## define taxon sets
spec <- rownames(ips.16S)
ingroup <- spec[grep("Ips|Orthomotomicus", spec)]
outgroup <- spec[grep("Pityogenes", spec)]
ts <- list(list(id = "ingroup", taxon = ingroup),
           list(id = "outgroup", taxon = outgroup))

## print XML file to screen
# rbeauti(ips.16S, taxonset = ts)
}
\references{
The XML reference at the BEAST 2 website:
  \url{http://beast.community/xml_reference} 
  Drummond, A.J. &
  A. Rambaut. 2007. BEAST: Bayesian evolutionary analysis by sampling trees.
  \emph{BMC Evolutionary Biology} \bold{7}: 240.
}
\seealso{
\code{\link{read.beast}}, \code{\link{read.beast.table}}
}
