% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.toolbox.R
\name{read.toolbox}
\alias{read.toolbox}
\title{Parse a Toolbox (SIL) text file}
\usage{
read.toolbox(path, text.fields.suppl = NULL, sentence.fields.suppl = c("tx",
  "nt", "ft"), word.fields.suppl = NULL, morpheme.fields.suppl = NULL)
}
\arguments{
\item{path}{length-1 character vector: the path to a toolbox text file.}

\item{text.fields.suppl}{character vector: the code of supplementary fields to be searched for each text (genre, ...). "id" is mandatory and need not to be listed here.}

\item{sentence.fields.suppl}{character vector: the code of supplementary fields to be searched for each sentence (such as ft, nt). "ref" is mandatory and need not to be listed here.}

\item{word.fields.suppl}{character vector: the code of supplementary fields to be searched for each word. "tx" is mandatory and need not to be listed here.}

\item{morpheme.fields.suppl}{character vector: the code of supplementary fields to be searched for each morpheme. "mb", "ge", "ps" are mandatory and need not to be listed here.}
}
\value{
a list with four slots "texts", "sentences", "words" and "morphemes",
each one containing a data frame. In these data frame, each row describe an occurrence
of the corresponding unit.
}
\description{
Parse a Toolbox (SIL) text file
}
\examples{
corpuspath <- system.file("exampleData", "tuwariToolbox.txt", package="interlineaR")
corpus <- read.toolbox(corpuspath)
}
\references{
https://software.sil.org/toolbox/
}
\seealso{
\link{read.emeld} (XML vocabulary for interlinearized glossed texts)
}
