% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{eventWeek}
\alias{eventWeek}
\title{Scheduling interim analyses in clinical trials in a time-to-event setting}
\usage{
eventWeek(t, p)
}
\arguments{
\item{t}{result of function \code{event}.}

\item{p}{number of events for which the week shall be determined.}
}
\value{
The week in which the number of events is reached.
}
\description{
Function \code{eventWeek} determines the week of the trial in which a certain number \code{t}
of events occured.
}
\details{
\code{eventWeek} is an auxilliary function required to assess the timing of interim analyses. It derives
the week of trial in which a certain number of events occured.

The output is required for function \code{cross}, which includes the information into an existing Event diagram.
}
\examples{
x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
y=treatment(r=x,dr=0.08,du=50)
eventCourse(r=x,e1=y)
trialWeek(t=y,p=50)
}
\seealso{
\code{\link{cross}} for plotting results of function \code{eventWeek} into an existing Event diagram.
}
