% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interep.R
\name{interep}
\alias{interep}
\title{fit generalized estimaitng equations with given tuning parameters}
\usage{
interep(e, g, y, beta0, corre, pmethod, lam1, lam2, maxits)
}
\arguments{
\item{e}{matrix of environment factors.}

\item{g}{matrix of omics factors. In the case study, the omics measurements are lipidomics data.}

\item{y}{the longitudinal response.}

\item{beta0}{the inital coefficient vector.}

\item{corre}{the working correlation structure that is used in the estimation algorithm. interep provides three choices for the
working correlation structure: "a" as AR-1", "i" as "independence" and "e" as "exchangeable".}

\item{pmethod}{the penalization method. "mixed" refers to MCP penalty to individual main effects and group MCP penalty to interactions; "individual" means MCP penalty to all effects.}

\item{lam1}{the tuning parameter lambda1 for individual predictors.}

\item{lam2}{the tuning parameter lambda2 for interactions.}

\item{maxits}{the maximum number of iterations that is used in the estimation algorithm.  The default value is 30}
}
\value{
\item{coef}{the coefficient vector.}
}
\description{
This function makes predictions for generalized estimating equation with a given value of lambda.
Typical usage is to have the cv.interep function compute the optimal lambda, then provide it to
the interep function.
}
\examples{
data("dat")
e=dat$e
g=dat$z
y=dat$y
beta0=dat$coef
index=dat$index
b = interep(e, g, y,beta0,corre="e",pmethod="mixed",lam1=dat$lam1, lam2=dat$lam2,maxits=30)
b[abs(b)<0.05]=0
pos = which(b != 0)
tp = length(intersect(index, pos))
fp = length(pos) - tp
list(tp=tp, fp=fp)

}
\references{
Zhou, F., Ren, J., Li, G., Jiang, Y., Li, X., Wang, W.and Wu, C. (2019). Penalized variable selection for Lipid--environment interactions in a longitudinal lipidomics study.
\href{https://www.mdpi.com/2073-4425/10/12/1002}{\emph{Genes}, 10(12), 1002}

Zhou, F., Ren, J., Liu, Y., Li, X., Wang, W.and Wu, C. (2022). Interep: An r package for high-dimensional interaction analysis of the repeated measurement data.
{\emph{Genes}, 13(3): 554} \doi{10.3390/genes13030544}

Zhou, F., Ren, J., Lu, X., Ma, S. and Wu, C. (2021) Gene–Environment Interaction: a Variable Selection Perspective.
\href{https://link.springer.com/protocol/10.1007/978-1-0716-0947-7_13}{\emph{Epistasis: Methods and Protocols}, 191-223}
}
