% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getComments.R
\name{getComments}
\alias{getComments}
\title{Returns up to 150 comments on an instagram post}
\usage{
getComments(id, token, verbose = TRUE)
}
\arguments{
\item{id}{String, id of instagram post.}

\item{token}{An OAuth token created with \code{instaOAuth}.}

\item{verbose}{If \code{TRUE} (default), outputs details about progress
of function on the console.}
}
\description{
\code{getComments} retrieves up to 150 recent comments on an instagram post, 
including text, author and date.
}
\details{
IMPORTANT: After June 1st, 2016 only applications that have passed permission
review by Instagram will be allowed to access data for users other than the
authenticated user. See  \url{https://www.instagram.com/developer/review/} 
for more information.
}
\examples{
\dontrun{
## See examples for instaOAuth to know how token was created.
## Downloading list of followers of @senjohnmccain
 load("my_oauth")
 obama <- getUserMedia( username="barackobama", token=my_oauth )
 comments <- getComments( obama$id[1], token=my_oauth )
}

}
\author{
Pablo Barbera \email{pablo.barbera@nyu.edu}
}

