% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{comp_manipulate}
\alias{comp_manipulate}
\title{Computational manipulation of cells}
\usage{
comp_manipulate(
  exir_output = NULL,
  graph = NULL,
  ko_vertices = igraph::V(graph),
  upregulate_vertices = igraph::V(graph),
  beta = 0.5,
  gamma = 1,
  no.sim = 100,
  node_verbose = FALSE,
  loop_verbose = TRUE,
  ncores = "default",
  seed = 1234
)
}
\arguments{
\item{exir_output}{The output of the ExIR model (optional).}

\item{graph}{A graph (network) of the igraph class (not required if the exir_output is inputted).}

\item{ko_vertices}{A vector of desired vertices/features to knockout. Default is set to V(graph) meaning to assess
the knockout of all vertices/features.}

\item{upregulate_vertices}{A vector of desired vertices/features to up-regulate. Default is set to V(graph) meaning to assess
the up-regulation of all vertices/features.}

\item{beta}{Non-negative scalar corresponding to the SIRIR model. The rate of infection of an individual that is susceptible
and has a single infected neighbor. The infection rate of a susceptible individual with n
infected neighbors is n times beta. Formally this is the rate parameter of an exponential
distribution.}

\item{gamma}{Positive scalar corresponding to the SIRIR model. The rate of recovery of an infected individual.
Formally, this is the rate parameter of an exponential distribution.}

\item{no.sim}{Integer scalar corresponding to the SIRIR model. The number of simulation runs to perform SIR model on for the
original network as well perturbed networks generated by leave-one-out technique.
You may choose a different no.sim based on the available memory on your system.}

\item{node_verbose}{Logical; whether the process of Parallel Socket Cluster creation should be printed (default is FALSE).}

\item{loop_verbose}{Logical; whether the accomplishment of the evaluation of network nodes in each loop should be printed (default is TRUE).}

\item{ncores}{Integer; the number of cores to be used for parallel processing. If ncores == "default" (default), the number of 
cores to be used will be the max(number of available cores) - 1. We recommend leaving ncores argument as is (ncores = "default").}

\item{seed}{A single value, interpreted as an integer to be used for random number generation.}
}
\value{
Depending on the input data, a list including one to three data frames of knockout/up-regulation rankings.
}
\description{
This function works based on the SIRIR (SIR-based Influence Ranking) model and could be applied on the
output of the ExIR model or any other independent association network. For feature (gene/protein/etc.)
knockout the SIRIR model is used to remove the feature from the network and assess its impact on the
flow of information (signaling) within the network. On the other hand, in case of up-regulation a node similar
to the desired node is added to the network with exactly the same connections (edges) as of the original node.
Next, the SIRIR model is used to evaluate the difference in the flow of information/signaling after adding (up-regulating)
the desired feature/node compared with the original network. In case you are applying this function on the output of
ExIR model, you may note that as the gene/protein knockout would impact on the integrity of the under-investigation network
as well as the networks of other overlapping biological processes/pathways, it is recommended to select those features that
simultaneously have the highest (most significant) ExIR-based rank and lowest knockout rank. In contrast, as the up-regulation
would not affect the integrity of the network, you may select the features with highest (most significant) ExIR-based and
up-regulation-based ranks.
A shiny app has also been developed for Running the ExIR model, visualization of its results as well as computational
simulation of knockout and/or up-regulation of its top candidate outputs, which is accessible using
the `influential::runShinyApp("ExIR")` command.
You can also access the shiny app online at https://influential.erc.monash.edu/.
}
\examples{
\dontrun{
set.seed(1234)
My_graph <- igraph::sample_gnp(n=50, p=0.05)
GraphVertices <- V(My_graph)
Computational_manipulation <- comp_manipulate(graph = My_graph, beta = 0.5,
                                              gamma = 1, no.sim = 10, seed = 1234)
                                              }
}
\seealso{
\code{\link[influential]{exir}}, \code{\link[influential]{sirir}},
and \code{\link[igraph]{sir}} for a complete description on SIR model

Other integrative ranking functions: 
\code{\link{exir}()},
\code{\link{hubness.score}()},
\code{\link{ivi.from.indices}()},
\code{\link{ivi}()},
\code{\link{spreading.score}()}
}
\concept{integrative ranking functions}
\keyword{comp_manipulate}
