% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_evaluation.R
\name{plot_edges_comparison}
\alias{plot_edges_comparison}
\title{Network Edge Comparison Visualization}
\usage{
plot_edges_comparison(
  network_table,
  ground_truth,
  color_pattern = list(predicted = "gray", ground_truth = "#bb141a", overlap = "#1966ad",
    total = "#6C757D")
)
}
\arguments{
\item{network_table}{A data frame of predicted network structure.}

\item{ground_truth}{A data frame of ground truth network.}

\item{color_pattern}{A list of colors for different categories.}
}
\value{
A patchwork plot object containing network edge comparison and distribution plots
}
\description{
Generates visualizations comparing edges of two networks.
}
\examples{
data(example_matrix)
data("example_ground_truth")
network_table <- inferCSN(example_matrix)
plot_edges_comparison(
  network_table,
  example_ground_truth
)
}
