% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_hash.R
\name{generate_hash}
\alias{generate_hash}
\title{Generate a Consistent Hash for an Argument List}
\usage{
generate_hash(
  parameters_list,
  hash_includes_timestamp = FALSE,
  ignore_na = TRUE,
  alphabetical_order = TRUE,
  algo = "xxhash64",
  ignore_script_name = FALSE
)
}
\arguments{
\item{parameters_list}{A named list of arguments for which the hash will be generated. Each element in the list should correspond to a parameter.}

\item{hash_includes_timestamp}{Logical; if FALSE, any timestamp included in parameters_list will be removed before hash generation. If TRUE, the timestamp will be included in the hash calculation.}

\item{ignore_na}{Logical; if TRUE, any NA values in parameters_list will be removed before hash generation.}

\item{alphabetical_order}{Logical; if TRUE, the arguments in parameters_list will be sorted alphabetically by their names before hash generation.}

\item{algo}{The hash algorithm to use (See \code{?digest})}

\item{ignore_script_name}{Logical. If \code{TRUE}, the script name is ignored during hash generation.}
}
\value{
A character string representing the hash value of the provided argument list.
}
\description{
This function generates a hash value for a given list of arguments. It is designed to produce a consistent hash by optionally removing NA values, ordering arguments alphabetically, handling timestamp inclusion, etc.
}
\examples{
args <- list(param1 = "value1", param2 = 100, param3 = NA)
generate_hash(args)
}
