% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{validate_logical_vector}
\alias{validate_logical_vector}
\title{Validate a Logical Subgroup Vector}
\usage{
validate_logical_vector(subgroup, N, name = NULL)
}
\arguments{
\item{subgroup}{A logical vector representing the subgroup to be validated.}

\item{N}{Length the subgroup should have.}

\item{name}{(Optional) A string indicating the name of group.}
}
\value{
The original \code{subgroup} vector if it passes all validation checks.
}
\description{
This function checks if a given vector is a logical vector (\code{TRUE}/\code{FALSE})
and whether its length matches the number of rows in a specified matrix.
It is designed to validate subgroup vectors used for subsettin data.
}
\details{
This function performs two key validations:
\enumerate{
\item Checks if the \code{subgroup} vector is logical.
\item Checks if the length of the \code{subgroup} vector matches the N.
}
}
