% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomizer.R
\name{randomize}
\alias{randomize}
\title{Randomly Assign Treatment While Controlling for Baseline Equivalency}
\usage{
randomize(
  data,
  variables,
  standard = "Not Concerned",
  seed = NULL,
  max_attempts = 100,
  pr_treated = 0.5,
  group_by = NULL
)
}
\arguments{
\item{data}{The input data frame containing pre-intervention variables.}

\item{variables}{A vector of the names of the pre-intervention
variables to check
for baseline equivalency.}

\item{standard}{The desired level of baseline equivalence.
Must be one of "Not Concerned",
"Concerned", or "Very Concerned". Default is "Not Concerned".
("Not Concerned", "Concerned", or "Very Concerned").
Must be one of "Not Concerned", "Concerned", or "Very Concerned".}

\item{seed}{(Optional) An integer to set the random
seed for reproducibility of the
initial randomization attempt. Subsequent attempts will use new random seeds.}

\item{max_attempts}{The maximum number of randomization
attempts to make before stopping and returning an error.}

\item{pr_treated}{(Optional) The probability of a row being assigned to the
treatment group (TRUE). Default is 0.5.}

\item{group_by}{(Optional) A character vector of column names to stratify the
randomization. If provided, the randomization will be done within each group
defined by the specified columns.}
}
\value{
A new data frame with the added "treated"
column, if baseline equivalency is achieved within the specified number of
attempts. Otherwise, an error is thrown.
}
\description{
This function repeatedly randomizes treatment
assignment (using \code{.randomizer}) until
baseline equivalency is achieved across specified
variables, as measured by the \code{checkBaseline} function from
the \code{im} package. It can optionally stratify the randomization by
specified groups.
}
