% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report}
\alias{report}
\title{Generates report about a conducted igate.}
\usage{
report(df, versus = 8, target, type = "continuous", test = "w",
  ssv = NULL, outlier_removal_target = TRUE,
  outlier_removal_ssv = TRUE, good_outcome = "low", results_path,
  validation = FALSE, validation_path = NULL,
  validation_counts = NULL, validation_summary = NULL,
  image_directory = tempdir(), output_name = NULL, output_directory)
}
\arguments{
\item{df}{The data frame that was analysed with \code{\link{igate}} or \code{\link{categorical.igate}}.}

\item{versus}{What value of \code{versus} was used?}

\item{target}{What \code{target} was used?}

\item{type}{Was \code{\link{igate}} (use \code{type = "continuous"}) or \code{\link{categorical.igate}} (use \code{type = "categorical"}) conducted?}

\item{test}{Which hypothesis test was used alongside the counting method?}

\item{ssv}{Which \code{ssv} have been used in the analysis? If \code{NULL}, it
will be assumed that \code{ssv = NULL} was passed to \code{\link{igate}} or \code{\link{categorical.igate}}
and all numeric variables in \code{df} will be used.}

\item{outlier_removal_target}{Was outlier removal conducted for \code{target}? If \code{type == "categorical"}
this is set to \code{FALSE} automatically.}

\item{outlier_removal_ssv}{Was outlier removal conducted for each \code{ssv}?}

\item{good_outcome}{Are \code{"low"} or \code{"high"} values of \code{target} good? Or, in
case of a categorical \code{target} the name of the best category as a string.}

\item{results_path}{Name of R object (as string) containing the results of \code{\link{igate}} or \code{\link{categorical.igate}}.}

\item{validation}{Logical. Has validation of the results been performed?}

\item{validation_path}{Name R object (as string) containing the validated observations, i.e. first data frame returned by \code{\link{validate}}.}

\item{validation_counts}{Name of R object (as string) containing the counts from validation, i.e. the second data frame returned by \code{\link{validate}}.}

\item{validation_summary}{Name of R object (as string) containing the summary of \code{validation_path}, i.e. the third data frame returned by \code{\link{validate}}.}

\item{image_directory}{Directory which contains the plots from \code{igate}, \code{igate.regressions} etc.}

\item{output_name}{Desired name of the output file. File extension .html will be added automatically if not supplied.
If \code{NULL} will be *iGATE_Report.html*.}

\item{output_directory}{Directory into which the report should be saved. To save to the current working directory,
use \code{output_directory = getwd()}.}
}
\value{
An html file named "iGATE_Report.html" will be output to the current working directory, containing details
about the conducted analysis. This includes a list of the analysed SSV, as well as tables with the results from
\code{\link{igate}}/ \code{\link{categorical.igate}} and plots from \code{\link{igate.regressions}}/
\code{\link{categorical.freqplot}}.
}
\description{
Takes results from a previous igate and automatically generates a html report
for it. Be aware that running this function will create an html document in your current working directory.
}
\examples{

## Example for categorical target variable
# If you want to conduct an igate analysis from scratch, running report
# is the last step and relies on executing the other functions in this package first.
# Run categorical.igate
df <- mtcars
df$cyl <- as.factor(df$cyl)
results <- categorical.igate(df, target = "cyl", best.cat = "8", worst.cat = "4")
# Produce density plots
# Suppose you only want to analyse further the first three identified ssv
results <- results[1:3,]
categorical.freqplot(mtcars, target = "cyl", ssv = results$Causes , savePlots = TRUE)

report(df = df, target = "cyl", type = "categorical", good_outcome = "8",
results_path = "results",
output_name = "testing_igate", output_directory = tempdir())


}
