% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ieTest_func.R
\name{ieTest}
\alias{ieTest}
\title{Testing the indirect effect.}
\usage{
ieTest(
  test,
  u = NULL,
  V = NULL,
  cov = NULL,
  df = NULL,
  V_0 = 0,
  V1Dist = NULL,
  V2Dist = NULL,
  V3Dist = NULL,
  numSquares = 10,
  upLim = 0.5,
  alpha = 0.05,
  interMult = 1
)
}
\arguments{
\item{test}{Denotes the test to be performed. ("maxP", "ps-test", "asq-test", "sobel", "sobel unordered")}

\item{u}{A vector with the U values to be used in the test. Given priority over estimates, but all must be supplied. Order defined in note.}

\item{V}{A vector containing the estimates to be used in the test. Must follow same order as u.}

\item{cov}{A matrix of the covariance matrix of the estimates in V. Must be square with dimensions compatible with V. Must follow same order as u.}

\item{df}{A vector of the degrees of freedom for the effect estimates. Length of 2 for single mediator, 3 for ordered.}

\item{V_0}{A vector containing the null values of the estimates to be used in the test. Defaults to zero.}

\item{V1Dist}{String value specifying the distribution of the estimate of the independent variable on the mediator.}

\item{V2Dist}{String value specifying the distribution of the second estimate.}

\item{V3Dist}{String value specifying the distribution of the third estimate (only needed for ordered scenario).}

\item{numSquares}{The number of squares to be used in the asq-test. Always superseded by upLim.}

\item{upLim}{The allowed extension, between 0 and 1, for the asq and ps-tests.}

\item{alpha}{A vector for the asq-test of significance levels to test. A value in the ps-test to control type I error.}

\item{interMult}{Integer indicating the level of the independent variable to use for the interaction terms.}
}
\value{
A p-value or p-value cutoff for the specified test for the indirect effect.
}
\description{
This function takes a vector estimates and a matrix of covariances 
or a vector of U values to be used in various indirect effect tests.
Estimate vectors with three parameters will default to single mediator
analysis (or one path of unordered mediation), and five parameters will
default to the ordered scenario. Values for the interaction term must
be provided for this wrapper. The user can then specify the distribution(s)
to be used as well as the test to be performed.
}
\note{
Order of parameters
Values must be in the correct order within u, V, and the cov matrix. 

\strong{Single mediator (or single path in unordered scenarios)}: \cr
Independent variable to mediator, mediator to response, 
interaction of independent and mediator.

\strong{Ordered mediators}: \cr
Independent variable to first mediator, 
first mediator to second mediator, interaction of independent and first mediator on second mediator, 
second mediator to response, interaction of independent and second mediator on response.

\strong{Combined Unordered Mediator}: \cr
Independent variable to first mediator, 
first mediator to response, interaction of independent and first mediator on response, 
Independent variable to second mediator, 
second mediator to response, interaction of independent and second mediator on response.
}
\examples{
ieTest( test = "ps-test", u = c(.015, .02, .998), alpha = 0.05, upLim = 0.5)

}
