% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_icfit.R
\name{summary.icfit}
\alias{summary.icfit}
\title{Summary method for an object of class `icfit`}
\usage{
\method{summary}{icfit}(
  object,
  lvl = 1,
  digits = max(1L, getOption("digits") - 3L),
  alpha = 0.05,
  ...
)
}
\arguments{
\item{object}{Object of class 'icfit'}

\item{lvl}{Describes the level of output}

\item{digits}{Number of digits to be printed}

\item{alpha}{Alpha level to be used of confidence interval ((1-alpha) * 100 percent)}

\item{\dots}{Other arguments to summary}
}
\value{
None (invisible \code{NULL})
}
\description{
Summary method for an object of class `icfit`
}
\examples{
\donttest{
icf <- icfit(Surv(left, right, type='interval2') ~ period + gender + age, data=drugusers)
summary(icf)
summary(icf, lvl=0) # same as print(icf)
summary(icf, lvl=1) # extra information on iterations and computation time
}

}
