% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_predict_icfit.R
\name{plot.predict.icfit}
\alias{plot.predict.icfit}
\title{Plot method for an object of class `predict.icfit`}
\usage{
\method{plot}{predict.icfit}(
  x,
  type = c("hazard", "cumhazard", "survival", "probability"),
  conf.int = TRUE,
  fill = TRUE,
  fillcol = "lightgrey",
  ylim = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  selection = NULL,
  nrow = NULL,
  ncol = NULL,
  do_plot = TRUE,
  ...
)
}
\arguments{
\item{x}{The object of class 'predict.icfit' to be plotted}

\item{type}{Type of plot. Accepted choices: 'hazard' (default), 'cumhazard', 'survival' or 'probability'}

\item{conf.int}{If `TRUE` a 100*(1 - alpha) percent confidence interval is plotted}

\item{fill}{Fill area between lower and upper}

\item{fillcol}{The color for filling (default 'lightgrey')}

\item{ylim}{The y-limits for the plot}

\item{title}{Optional title string, or, if x is a list, obtained from 'predict.icfit' using `newdata`,
a vector of title strings}

\item{xlab}{Text for x-label}

\item{ylab}{Text for y-label}

\item{selection}{If x is a list, obtained from 'predict.icfit' using `newdata`, then a
vector containing the subset of list elements to be plotted, default is to plot
all elements of the list}

\item{nrow}{If x is a list, obtained from 'predict.icfit' using `newdata`, then a number
specifying the number of rows to plot; default the square root of the number of list
elements to be plotted}

\item{ncol}{If x is a list, obtained from 'predict.icfit' using `newdata`, then a number
specifying the number of columns to plot; default the square root of the number of list
elements to be plotted}

\item{do_plot}{Boolean indicating whether or not to actually plot (default is TRUE)}

\item{...}{other graphical parameters to be passed on}
}
\value{
A ggplot grob, containing the plot. Use \code{print()} or \code{plot()} to show it
Multiple objects can be combined by using functions in the package \code{gridExtra}.
}
\description{
Plot method for an object of class `predict.icfit`
}
\examples{
\donttest{
icf <- icfit(Surv(left, right, type='interval2') ~ period + gender + age, data=drugusers)
pred_icf <- predict(icf)
plot(pred_icf)
library(ggplot2)
plot(icf) + xlim(0, 200) + ylim(0, 0.05)
ndata <- drugusers[1:4, ]
pred_nd_icf <- predict(icf, newdata=ndata)
plot(pred_nd_icf) # plot all four
plot(pred_nd_icf[[2]]) # plot only the second
plot(pred_nd_icf, type = "cumhazard") # plot four cumulative hazard curves
plot(pred_nd_icf[[3]], type = "prob", ylim = c(0, 1)) # plot probability curve for nr 3
plot(pred_nd_icf[[4]], type = "surv", ylim = c(0, 1)) # plot survival curve for nr 4
}

}
