% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_input_icfit.R
\name{get_input_icfit}
\alias{get_input_icfit}
\title{Get and check input of icfit}
\usage{
get_input_icfit(formula, data, entry)
}
\arguments{
\item{formula}{A formula object with response of the left of a ~ operator
and terms on the right. The response must be a survival object as returned
by the `Surv` function, with type either right', 'counting' or 'interval2'}

\item{data}{A data frame in which to interpret the variable names in the
`formula`}

\item{entry}{When appropriate, a vector of entry (left truncation) times,
or a string indicating the column name in `data` containing entry times;
only used if Surv object is of type 'interval2'}
}
\value{
A list with items
\item{Ymat}{Matrix (number of subjects x 3) containing entry, left and right
hand of intervals}
\item{X}{Matrix (number of subjects x number of covariates + 1) with design
matrix of covariates}
}
\description{
Get and check input of icfit
}
