% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_functions.R
\name{get_F_at_x}
\alias{get_F_at_x}
\title{Generic Function to compute F at X}
\usage{
get_F_at_x(object, ...)
}
\arguments{
\item{object}{An object for which the method is defined.}

\item{...}{Additional arguments passed to the method.}
}
\value{
A numeric vector of values, either \eqn{F(x)} or \eqn{log(F(x))}.
}
\description{
Computes the value of the function \eqn{F(x)} for a given object of class \code{iclogcondist}. 
This is a generic function to compute \eqn{F(x)} for object class \code{iclogcondist}. 
For usage details, please refer to function \code{get_F_at_x.iclogcondist}
}
\examples{
# Example usage:
data(lgnm)

# Evaluate for LCMLE object
fit_LCMLE <- ic_LCMLE(lgnm)
get_F_at_x(fit_LCMLE)

# Evaluate for UMLE object
fit_UMLE <- ic_UMLE(lgnm)
x = seq(0.001, 6, length.out = 1000)
get_F_at_x(fit_UMLE, x = x)
}
