% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{icertool}
\alias{icertool}
\title{Calculate the ICER and Plot the Efficiency Frontier}
\usage{
icertool()
}
\description{
The app will calculate the ICER (incremental cost-effectiveness
             ratio) (Rawlins, 2012) \doi{10.1016/B978-0-7020-4084-9.00044-6} from the mean
             costs and quality-adjusted life years (QALY) (Torrance and Feeny, 2009) \doi{10.1017/S0266462300008461}
             for a set of treatment options, and draw the efficiency frontier
             in the costs-effectiveness plane. The app automatically identifies
             and excludes dominated and extended-dominated options from the ICER
             calculation.
}
\examples{
if (interactive()){

data.0 <- as.data.frame(read_excel("icer.xlsx"))

cq<-myicer(data.0)

my_ce <- ce_plot(data.0,cq)

my_ce + theme(text = element_text(size = 12)) + geom_text_repel()

cq


}
}

\value{
The function 'icertool()' does not return a value. 'icertool()' returns a
plot that can be copied from the graphical interface.

In the results tab, to copy an image of the graph to a word-processor document,
right-click with your mouse on the graph and select 'Copy image', then go
to your word-processor document and select 'Paste Special' and 'Bitmap image'
}
