% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inheritance_pattern.R
\name{inheritance_pattern}
\alias{inheritance_pattern}
\title{Inheritance pattern for inheritance vectors}
\usage{
inheritance_pattern(inheritance_space, v)
}
\arguments{
\item{inheritance_space}{Output of \link{inheritance_space}.}

\item{v}{Integer.}
}
\value{
Data frame describing inheritance pattern and IBD state for each \code{v}.
}
\description{
The \code{inheritance_pattern} function determines the inheritance pattern for all
pedigree members by dropping the founder allele labels down the pedigree
according to the IBD vector \code{v}.
}
\examples{
ped_fs <- pedtools::nuclearPed(nch = 2)
i <- inheritance_space(ped_fs, ids = 3:4)

# show the inheritance pattern and IBD state for all canonical IBD vectors
inheritance_pattern(i, v = 0:3)

# without exploiting founder symmetry
i2 <- inheritance_space(ped_fs, ids = 3:4, exploit_symmetries = FALSE)
inheritance_pattern(i2, v = 0:15)
}
