% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iaibase.R
\name{score.default}
\alias{score.default}
\title{Calculate the score for a set of predictions on the given data}
\usage{
\method{score}{default}(obj, predictions, truths, ...)
}
\arguments{
\item{obj}{The type of problem.}

\item{predictions}{The predictions to evaluate.}

\item{truths}{The true target values for these observations.}

\item{...}{Other parameters, including the criterion. Refer to the Julia
documentation for available parameters.}
}
\description{
Julia Equivalent:
\href{https://docs.interpretable.ai/v3.2.2/IAIBase/reference/#IAI.score-Tuple\%7BUnion\%7BAbstractString\%2C\%20Symbol\%7D\%2C\%20Vararg\%7BAny\%7D\%7D}{\code{IAI.score}}
}
\section{IAI Compatibility}{

Requires IAI version 2.1 or higher.
}

\examples{
\dontrun{iai::score("regression", y_pred, y_true, criterion="mse")}

}
