% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{compute.config.matrix}
\alias{compute.config.matrix}
\title{Computes a configuration matrix}
\usage{
compute.config.matrix(x, similarity_fun = inner.product, center = TRUE,
  mod.rv = TRUE)
}
\arguments{
\item{x}{Data matrix.}

\item{similarity_fun}{A function pointer to the similarity function to be used (default=inner.product).}

\item{center}{A boolean indicating whether centering should be used (default=TRUE).}

\item{mod.rv}{A boolean indicating whether the modified RV coefficient should be used (default=TRUE).}
}
\value{
A configuration matrix.
}
\description{
Given a data matrix, this function computes the configuration matrix for the corresponding dataset. You'll typically won't need to call
this function directly, but should use compute.config.matrices() instead, as it will make determining partial RV coefficients, p-values and confidence
intervals easier later on.
}
\examples{
set.seed(2)
n = 100
p = 100
x1 = matrix(rnorm(n*p), n, p)
x2 = x1 + matrix(rnorm(n*p), n, p)
S1 = compute.config.matrix(x1)
S2 = compute.config.matrix(x1)
rv.coef(S1, S2)
}
