% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_Function.R
\name{iSTAY_Multiple}
\alias{iSTAY_Multiple}
\title{Calculate stability and synchrony for multiple time series.}
\usage{
iSTAY_Multiple(
  data,
  order.q = c(1, 2),
  Alltime = TRUE,
  start_T = NULL,
  end_T = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} containing multiple time series data, with sampling units as rows and time points as columns, or a \code{list} of \code{data.frames} with each data frame representing multiple time series.}

\item{order.q}{A numerical vector specifying the orders of stability and synchrony. Default is c(1,2).}

\item{Alltime}{Logical (\code{TRUE} or \code{FALSE}), indicating whether to use all time points in the data.}

\item{start_T}{(Applicable only if \code{Alltime = FALSE}) a positive integer specifying the starting column (time point) for the analysis interval.}

\item{end_T}{(Applicable only if \code{Alltime = FALSE}) a positive integer specifying the ending column (time point) for the analysis interval.}
}
\value{
a data frame with the following columns: \cr
 Dataset: the input dataset \cr
 Order_q: order of stability or synchrony \cr
 Gamma, Alpha, Beta: stability measures of order q \cr 
 Synchrony: synchrony measure of order q
}
\description{
\code{iSTAY_Multiple} computes gamma, alpha, and beta stability, as well as synchrony, for multiple time-series data.
}
\examples{
# Stability of multiple time series
data("Data_Jena_20_metacommunities")
metacommunities <- Data_Jena_20_metacommunities
output_metacommunities <- iSTAY_Multiple(data = metacommunities, order.q = c(1,2), Alltime = TRUE)
output_metacommunities

# Stability of metapopulations
data("Data_Jena_76_metapopulations")
metapopulations <- Data_Jena_76_metapopulations
output_metapopulations <- iSTAY_Multiple(data = metapopulations, order.q = c(1,2), Alltime = TRUE)
output_metapopulations


}
