% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_save_classification.R
\name{ifcb_save_classification}
\alias{ifcb_save_classification}
\title{Classify an IFCB Sample and Save Results}
\usage{
ifcb_save_classification(
  roi_file,
  output_folder,
  format = c("h5", "mat", "csv"),
  gradio_url = "https://irfcb-classify.hf.space",
  model_name = "SMHI NIVA ResNet50 V5",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{roi_file}{A character string specifying the path to the \code{.roi} file.}

\item{output_folder}{A character string specifying the directory where the
output file will be saved. The file is named automatically based on
the sample name (e.g. \code{D20220522T003051_IFCB134_class.h5},
\code{D20220522T003051_IFCB134_class_v1.mat}, or
\code{D20220522T003051_IFCB134.csv}).}

\item{format}{A character string specifying the output format. One of
\code{"h5"} (default), \code{"mat"}, or \code{"csv"}.}

\item{gradio_url}{A character string specifying the base URL of the Gradio
application. Default is \code{"https://irfcb-classify.hf.space"}, which is an
example Hugging Face Space with limited resources intended for testing and
demonstration. For large-scale classification, deploy your own instance of
the classification app (source code:
\url{https://github.com/EuropeanIFCBGroup/ifcb-inference-app}) and
pass its URL here.}

\item{model_name}{A character string specifying the name of the CNN model
to use for classification. Default is \code{"SMHI NIVA ResNet50 V5"}. Use
\code{\link[=ifcb_classify_models]{ifcb_classify_models()}} to list all available models.}

\item{verbose}{A logical value indicating whether to print progress messages.
Default is \code{TRUE}.}

\item{...}{Additional arguments passed to \code{\link[=ifcb_extract_pngs]{ifcb_extract_pngs()}} (e.g.
\code{ROInumbers}, \code{gamma}).}
}
\value{
The path to the saved file (invisibly).
}
\description{
Extracts PNG images from an IFCB \code{.roi} file, classifies each image via the
Gradio API \code{predict_scores} endpoint (returning all class scores), fetches
per-class thresholds, and writes the results in the specified format.
}
\details{
Three output formats are supported:
\describe{
\item{\code{"h5"}}{IFCB Dashboard class_scores v3 HDF5 format. Contains \code{output_scores},
\code{class_labels}, \code{roi_numbers} (Dashboard-required), plus
\code{classifier_name}, \code{class_name}, \code{class_name_auto}, and \code{thresholds}.
Requires the \pkg{hdf5r} package.}
\item{\code{"mat"}}{IFCB Dashboard class_scores v1 MATLAB format. Contains \code{class2useTB},
\code{TBscores}, \code{roinum}, \code{TBclass}, \code{TBclass_above_threshold}, and
\code{classifierName}. Requires Python with \pkg{scipy} and \pkg{numpy}.}
\item{\code{"csv"}}{\code{ClassiPyR}-compatible CSV format with columns \code{file_name},
\code{class_name} (threshold-applied), \code{class_name_auto} (winning class
without threshold), and \code{score} (winning class confidence). See
\url{https://github.com/EuropeanIFCBGroup/ClassiPyR} for details.}
}
}
\examples{
\dontrun{
# Classify a sample and save as HDF5 (default)
ifcb_save_classification(
  "path/to/D20220522T003051_IFCB134.roi",
  output_folder = "output"
)

# Save as Dashboard v1 .mat format
ifcb_save_classification(
  "path/to/D20220522T003051_IFCB134.roi",
  output_folder = "output",
  format = "mat"
)

# Save as CSV
ifcb_save_classification(
  "path/to/D20220522T003051_IFCB134.roi",
  output_folder = "output",
  format = "csv"
)
}

}
\seealso{
\code{\link[=ifcb_classify_images]{ifcb_classify_images()}}, \code{\link[=ifcb_classify_sample]{ifcb_classify_sample()}},
\code{\link[=ifcb_classify_models]{ifcb_classify_models()}}
}
