% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_extract_pngs.R
\name{ifcb_extract_pngs}
\alias{ifcb_extract_pngs}
\title{Extract Images from IFCB ROI File}
\usage{
ifcb_extract_pngs(
  roi_file,
  out_folder = dirname(roi_file),
  ROInumbers = NULL,
  taxaname = NULL,
  gamma = 1,
  normalize = FALSE,
  overwrite = FALSE,
  scale_bar_um = NULL,
  scale_micron_factor = 1/3.4,
  scale_bar_position = "bottomright",
  scale_bar_color = "black",
  old_adc = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{roi_file}{A character string specifying the path to the \code{.roi} file.}

\item{out_folder}{A character string specifying the directory where the PNG images will be saved. Defaults to the directory of the ROI file.}

\item{ROInumbers}{An optional numeric vector specifying the ROI numbers to extract. If NULL, all ROIs with valid dimensions are extracted.}

\item{taxaname}{An optional character string specifying the taxa name for organizing images into subdirectories. Defaults to NULL.}

\item{gamma}{A numeric value for gamma correction applied to the image. Default is 1 (no correction). Values <1 brighten dark regions, while values >1 darken the image.}

\item{normalize}{A logical value indicating whether to apply min-max normalization to stretch pixel values to the full 0-255 range. Default is FALSE, which preserves raw pixel values from the camera, producing images comparable to IFCB Dashboard and other standard IFCB software. Set to TRUE to stretch contrast to the full 0-255 range.}

\item{overwrite}{A logical value indicating whether to overwrite existing PNG files. Default is FALSE.}

\item{scale_bar_um}{An optional numeric value specifying the length of the scale bar in micrometers. If NULL, no scale bar is added.}

\item{scale_micron_factor}{A numeric value defining the conversion factor from micrometers to pixels. Defaults to 1/3.4.}

\item{scale_bar_position}{A character string specifying the position of the scale bar in the image. Options are \code{"topright"}, \code{"topleft"}, \code{"bottomright"}, or \code{"bottomleft"}. Defaults to \code{"bottomright"}.}

\item{scale_bar_color}{A character string specifying the scale bar color. Options are \code{"black"} or \code{"white"}. Defaults to \code{"black"}.}

\item{old_adc}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Previously used to indicate old ADC format. ADC format is now auto-detected
from the HDR file and column count. This parameter is ignored.}

\item{verbose}{A logical value indicating whether to print progress messages. Default is TRUE.}
}
\value{
This function is called for its side effects: it writes PNG images to a directory.
}
\description{
This function reads an IFCB (\code{.roi}) file and its corresponding \code{.adc} file, extracts regions of interest (ROIs),
and saves each ROI as a PNG image in a specified directory. Optionally, you can specify ROI numbers
to extract, useful for specific ROIs from manual or automatic classification results. Additionally, a scale bar
can be added to the extracted images based on a specified micron-to-pixel conversion factor.
}
\examples{
\dontrun{
# Convert ROI file to PNG images
ifcb_extract_pngs("path/to/your_roi_file.roi")

# Extract specific ROI numbers from ROI file
ifcb_extract_pngs("path/to/your_roi_file.roi", "output_directory", ROInumbers = c(1, 2, 3))

# Extract images with a 5 micrometer scale bar
ifcb_extract_pngs("path/to/your_roi_file.roi", scale_bar_um = 5)
}
}
\seealso{
\code{\link{ifcb_extract_classified_images}} for extracting ROIs from automatic classification.

\code{\link{ifcb_extract_annotated_images}} for extracting ROIs from manual annotation.
}
