% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_extract_biovolumes.R
\name{ifcb_extract_biovolumes}
\alias{ifcb_extract_biovolumes}
\title{Extract Biovolumes from IFCB Data and Compute Carbon Content}
\usage{
ifcb_extract_biovolumes(
  feature_files,
  class_files = NULL,
  custom_images = NULL,
  custom_classes = NULL,
  class2use_file = NULL,
  micron_factor = 1/3.4,
  diatom_class = "Bacillariophyceae",
  diatom_include = NULL,
  marine_only = FALSE,
  threshold = "opt",
  multiblob = FALSE,
  feature_recursive = TRUE,
  class_recursive = TRUE,
  drop_zero_volume = FALSE,
  feature_version = NULL,
  use_python = FALSE,
  verbose = TRUE,
  mat_folder = deprecated(),
  mat_files = deprecated(),
  mat_recursive = deprecated()
)
}
\arguments{
\item{feature_files}{A path to a folder containing feature files or a character vector of file paths.}

\item{class_files}{(Optional) A character vector of full paths to classification or manual
annotation files (\code{.mat}, \code{.h5}, or \code{.csv}), or a single path to a folder
containing such files.}

\item{custom_images}{(Optional) A character vector of image filenames in the format DYYYYMMDDTHHMMSS_IFCBXXX_ZZZZZ(.png),
where "XXX" represents the IFCB number and "ZZZZZ" represents the ROI number.
These filenames should match the \code{roi_number} assignment in the \code{feature_files} and can be
used as a substitute for classification files.}

\item{custom_classes}{(Optional) A character vector of corresponding class labels for \code{custom_images}.}

\item{class2use_file}{(Optional) A character string specifying the path to the file containing the \code{class2use} variable. Only required for manual results (default: NULL).}

\item{micron_factor}{Conversion factor from microns per pixel (default: 1/3.4).}

\item{diatom_class}{A character vector specifying diatom class names in WoRMS. Default: \code{"Bacillariophyceae"}.}

\item{diatom_include}{Optional character vector of class names that should always be treated as diatoms,
overriding the boolean result of \code{ifcb_is_diatom}. Default: NULL.}

\item{marine_only}{Logical. If \code{TRUE}, restricts the WoRMS search to marine taxa only. Default: \code{FALSE}.}

\item{threshold}{A character string controlling which classification to use.
\code{"opt"} (default) uses the threshold-applied classification, where
predictions below the per-class optimal threshold are labeled
\code{"unclassified"}. Any other value (e.g. \code{"all"}) uses the raw winning
class without any threshold applied.}

\item{multiblob}{Logical. If \code{TRUE}, includes multiblob features. Default: \code{FALSE}.}

\item{feature_recursive}{Logical. If \code{TRUE}, searches recursively for feature files when \code{feature_files} is a folder. Default: \code{TRUE}.}

\item{class_recursive}{Logical. If \code{TRUE} and \code{class_files} is a folder, searches recursively for classification files. Default: \code{TRUE}.}

\item{drop_zero_volume}{Logical. If \code{TRUE}, rows where \code{Biovolume} equals zero (e.g., artifacts such as smudges on the flow cell) are removed. Default: \code{FALSE}.}

\item{feature_version}{Optional numeric or character version to filter feature files by (e.g. 2 for "_v2"). Default is NULL (no filtering).}

\item{use_python}{Logical. If \code{TRUE}, attempts to read \code{.mat} files using a Python-based method (\code{SciPy}). Default: \code{FALSE}.}

\item{verbose}{Logical. If \code{TRUE}, prints progress messages. Default: \code{TRUE}.}

\item{mat_folder}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{class_files} instead.}

\item{mat_files}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{class_files} instead.}

\item{mat_recursive}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{class_recursive} instead.}
}
\value{
A data frame containing:
\itemize{
\item \code{sample}: The sample name.
\item \code{classifier}: The classifier used (if applicable).
\item \code{roi_number}: The region of interest (ROI) number.
\item \code{class}: The identified taxonomic class.
\item \code{biovolume_um3}: Computed biovolume in cubic micrometers.
\item \code{carbon_pg}: Estimated carbon content in picograms.
}
}
\description{
This function reads biovolume data from feature files generated by the \code{ifcb-analysis} repository (Sosik and Olson 2007)
and matches them with corresponding classification results or manual annotations. It calculates biovolume in cubic micrometers and
determines if each class is a diatom based on the World Register of Marine Species (WoRMS). Carbon content
is computed for each region of interest (ROI) using conversion functions from Menden-Deuer and Lessard (2000),
depending on whether the class is identified as a diatom.
}
\details{
\itemize{
\item \strong{Classification Data Handling:}
\itemize{
\item If \code{class_files} is provided, the function reads class annotations from \code{.mat}, \code{.h5}, or \code{.csv} files.
\item If \code{custom_images} and \code{custom_classes} are supplied, they override classification file data (e.g. data from a CNN model).
\item If both \code{class_files} and \code{custom_images/custom_classes} are given, \code{class_files} takes precedence.
}
\item \strong{MAT File Processing:}
\itemize{
\item If \code{use_python = TRUE}, the function reads \code{.mat} files using \code{ifcb_read_mat()} (requires Python + \code{SciPy}).
\item Otherwise, it falls back to \code{R.matlab::readMat()}.
}
}
}
\examples{
\dontrun{
# Using classification results:
feature_files <- "data/features"
class_files <- "data/classified"

biovolume_df <- ifcb_extract_biovolumes(feature_files,
                                        class_files)

print(biovolume_df)

# Using custom classification result:
classes <- c("Mesodinium_rubrum",
             "Mesodinium_rubrum")
images <- c("D20220522T003051_IFCB134_00002",
           "D20220522T003051_IFCB134_00003")

biovolume_df_custom <- ifcb_extract_biovolumes(feature_files,
                                               custom_images = images,
                                               custom_classes = classes)

print(biovolume_df_custom)
}

}
\references{
Menden-Deuer Susanne, Lessard Evelyn J., (2000), Carbon to volume relationships for dinoflagellates, diatoms, and other protist plankton, Limnology and Oceanography, 45(3), 569-579, doi: 10.4319/lo.2000.45.3.0569.

Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_read_features}} \code{\link{ifcb_is_diatom}} \url{https://www.marinespecies.org/}
}
