% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_classify_sample.R
\name{ifcb_classify_sample}
\alias{ifcb_classify_sample}
\title{Classify All Images in an IFCB Sample Using a Gradio Application}
\usage{
ifcb_classify_sample(
  roi_file,
  gradio_url = "https://irfcb-classify.hf.space",
  top_n = 1,
  model_name = "SMHI NIVA ResNet50 V5",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{roi_file}{A character string specifying the path to the \code{.roi} file.}

\item{gradio_url}{A character string specifying the base URL of the Gradio
application. Default is \code{"https://irfcb-classify.hf.space"}, which is an
example Hugging Face Space with limited resources intended for testing and
demonstration. For large-scale classification, deploy your own instance of
the classification app (source code:
\url{https://github.com/EuropeanIFCBGroup/ifcb-inference-app}) and
pass its URL here.}

\item{top_n}{An integer specifying the number of top predictions to return
per image. Default is \code{1} (top prediction only). Use \code{Inf} to return all
predictions.}

\item{model_name}{A character string specifying the name of the CNN model
to use for classification. Default is \code{"SMHI NIVA ResNet50 V5"}. Use
\code{\link[=ifcb_classify_models]{ifcb_classify_models()}} to list all available models.}

\item{verbose}{A logical value indicating whether to print progress messages.
Default is \code{TRUE}.}

\item{...}{Additional arguments passed to \code{\link[=ifcb_extract_pngs]{ifcb_extract_pngs()}} (e.g.
\code{ROInumbers}, \code{gamma}, \code{scale_bar_um}).}
}
\value{
A data frame with the following columns:
\describe{
\item{\code{file_name}}{The PNG file name of the classified image.}
\item{\code{class_name}}{The predicted class name with per-class thresholds
applied; \code{"unclassified"} if the score is below the threshold.}
\item{\code{class_name_auto}}{The winning class name without any threshold
applied (argmax of scores).}
\item{\code{score}}{The prediction confidence score (0–1).}
\item{\code{model_name}}{The name of the CNN model used for classification.}
}
Images that could not be classified have \code{NA} in \code{class_name},
\code{class_name_auto}, and \code{score}.
When \code{top_n > 1}, multiple rows are returned per image (one per prediction).
}
\description{
Extracts PNG images from an IFCB sample (\code{.roi} file) using
\code{\link[=ifcb_extract_pngs]{ifcb_extract_pngs()}} into a temporary directory, then classifies each
image through a CNN model served by a Gradio application. Per-class F2
optimal thresholds are applied automatically. The temporary directory is
automatically removed when the function exits.
}
\details{
To classify individual pre-extracted PNG files, use \code{\link[=ifcb_classify_images]{ifcb_classify_images()}}
directly.
}
\examples{
\dontrun{
# Classify all ROIs in a sample (top prediction per image)
result <- ifcb_classify_sample("path/to/D20220522T003051_IFCB134.roi")
head(result)

# Return top 3 predictions per image
result <- ifcb_classify_sample(
  "path/to/D20220522T003051_IFCB134.roi",
  top_n = 3
)

# Classify only specific ROI numbers
result <- ifcb_classify_sample(
  "path/to/D20220522T003051_IFCB134.roi",
  ROInumbers = c(1, 5, 10)
)
}

}
\seealso{
\code{\link[=ifcb_classify_images]{ifcb_classify_images()}} to classify pre-extracted PNG files
directly. \code{\link[=ifcb_classify_models]{ifcb_classify_models()}} to list available CNN models.
\code{\link[=ifcb_extract_pngs]{ifcb_extract_pngs()}} to extract PNG images from IFCB ROI files.
}
