% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hystreet_station_data.R
\name{get_hystreet_station_data}
\alias{get_hystreet_station_data}
\title{Get data from a specific location from the Hystreet Project via Hystreet API}
\usage{
get_hystreet_station_data(
  hystreetId = NULL,
  query = NULL,
  no_metadata = FALSE,
  API_token = NULL
)
}
\arguments{
\item{hystreetId}{\link{integer} (\strong{required}): ID of the requested station. See \code{\link[=get_hystreet_locations]{get_hystreet_locations()}} for an overview of
available IDs.}

\item{query}{\link{list} (\strong{optional}): A list with queries. Up do date the following queries are supported:
\itemize{
\item from: datetime of earliest measurement (default: today 00:00:00:): e.g. "2018-10-01 12:00:00" or "2018-10-01"
\item to : datetime of latest measurement (default: today 23:59:59): e.g. "2018-01-12 12:00:00" or "2018-12-01"
\item resolution: Resolution for the measurement grouping (default: hour): "day", "hour", "month", "week"
}}

\item{no_metadata}{\link{logical} (\strong{optional}): If set to \code{TRUE}, the result contains no meta data but only a clean data frame
with the measurements of the requested station. Defaults to \code{FALSE}.}

\item{API_token}{\link{character} (\strong{optional}): API key to get access to Hystreet API}
}
\value{
\link{data.frame} with parsed data from hystreet API
}
\description{
Get data from a specific location from the Hystreet Project via Hystreet API
}
\section{Function version}{

0.0.3
}

\examples{
\dontrun{
## request data of the current day of station with hystreetId 71
get_hystreet_station_data(71)

## request data of December 2018 with resolution "day"
get_hystreet_station_data(
   hystreetId = 71, 
   query = list(from = "2018-12-01", to = "2018-12-31", resolution = "day"))
 }
}
\author{
Johannes Friedrich, Yannik Buhl
}
