% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigate_connected_paths.R
\name{navigate_connected_paths}
\alias{navigate_connected_paths}
\title{Navigate Connected Paths}
\usage{
navigate_connected_paths(x, outlets, status = FALSE)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{outlets}{vector of ids from data.frame}

\item{status}{logical print status and progress bars?}
}
\value{
data.frame containing the distance between pairs of network outlets
and a list column containing flowpath identifiers along path that connect outlets.
For a network with one terminal outlet, the data.frame will have \code{nrow(x)^2} rows.
}
\description{
Given a dendritic network and set of ids, finds paths or
lengths between all identified flowpath outlets. This algorithm finds
paths between outlets regardless of flow direction.
}
\details{
Required attributes: \code{id}, \code{toid}, \code{length_km}
}
\examples{
x <- sf::read_sf(system.file("extdata", "walker.gpkg", package = "hydroloom"))

outlets <- c(5329303, 5329357, 5329317, 5329365, 5329435, 5329817)

x <- add_toids(hy(x))

navigate_connected_paths(x, outlets)

}
