% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scour.R
\name{scour_horz}
\alias{scour_horz}
\title{Scour depth and length (horizontal jet)}
\usage{
scour_horz(Q,B,h,h_u,d90,W=NULL,a=NULL,mu=NULL,l0=NULL,
method="Eggenberger")
}
\arguments{
\item{Q}{flow [m3/s]}

\item{B}{channel width [m]}

\item{h}{difference between upstream and downstream water table [m]}

\item{h_u}{downstream water table [m]}

\item{d90}{d90 of grain size distribution [mm]}

\item{W}{shape value. For free waved jet w = 15.4 and for covered waved jet
w = 10.35. If the parameters a and mu are known, W is calculated in the
function and must not be specified}

\item{a}{gate opeing height [m]}

\item{mu}{contraction value. Values between 0.6 (orthogonal gates) and 0.8
(inclined gates) are recommended [-]}

\item{l0}{length of fix sole protection downstream the gate [m] (for method Shalash)}

\item{method}{method to calculate scour depth. valid values are "Eggenberger"
or "Shalash". Independet of the chosen method, the position of the scour is
calculated according to "Eggenberger".}
}
\value{
\item{T0}{water table at maximal scour depth [m]}
\item{S}{maximal scour depth [m]}
\item{l1}{horizontal distance of maximal scour depth to overfall crest [m]}
\item{l2}{total horizontal distance of scour depth from overfall crest [m]}
}
\description{
Calculate scour depth and position (length) formed by horizontal jet
}
\examples{
## calculate scour depth accordint to Eggenberger returing all results
scour_horz(Q = 4, B = 1, h = 5, h_u = 1.76, d90 = 150, a = 1, mu = 0.6)

## calculate scour depth accordint to Eggenberger with given W value
scour_horz(Q = 4, B = 1, h = 5, h_u = 1.76, d90 = 150, W = 15.4)

## calculate scour depth accordint to Shalash with l0=5
scour_horz(
  Q = 4, B = 1, h = 5, h_u = 1.76, d90 = 150,
  method = "Shalash", l0 = 5, a = 1
)

}
\references{
Bezzola (2012). Vorlesungsmanuskript Flussbau. ETH Zürich.
}
