% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterLevelFlood1.R
\name{waterLevelFlood1}
\alias{waterLevelFlood1}
\title{Compute 1d water level data from the FLYS3 water level MQ and a
  gauging station according to the INFORM 3-method Flood1 (Flut1)}
\usage{
waterLevelFlood1(wldf, gauging_station, w, uuid, shiny = FALSE)
}
\arguments{
\item{wldf}{an object of class \linkS4class{WaterLevelDataFrame}.}

\item{gauging_station}{must be type \code{character} with a length of one. Permitted values are: 'SCHOENA', 'PIRNA', 'DRESDEN', 'MEISSEN', 'RIESA', 'MUEHLBERG', 'TORGAU', 'PRETZSCH-MAUKEN', 'ELSTER', 'WITTENBERG', 'COSWIG', 'VOCKERODE', 'ROSSLAU', 'DESSAU', 'AKEN', 'BARBY', 'SCHOENEBECK', 'MAGDEBURG-BUCKAU', 'MAGDEBURG-STROMBRUECKE', 'MAGDEBURG-ROTHENSEE', 'NIEGRIPP AP', 'ROGAETZ', 'TANGERMUENDE', 'STORKAU', 'SANDAU', 'SCHARLEUK', 'WITTENBERGE', 'MUEGGENDORF', 'SCHNACKENBURG', 'LENZEN', 'GORLEBEN', 'DOEMITZ', 'DAMNATZ', 'HITZACKER', 'NEU DARCHAU', 'BLECKEDE', 'BOIZENBURG', 'HOHNSTORF', 'ARTLENBURG', 'GEESTHACHT', 'IFFEZHEIM', 'PLITTERSDORF', 'MAXAU', 'PHILIPPSBURG', 'SPEYER', 'MANNHEIM', 'WORMS', 'NIERSTEIN-OPPENHEIM', 'MAINZ', 'OESTRICH', 'BINGEN', 'KAUB', 'SANKT GOAR', 'BOPPARD', 'BRAUBACH', 'KOBLENZ', 'ANDERNACH', 'OBERWINTER', 'BONN', 'KOELN', 'DUESSELDORF', 'RUHRORT', 'WESEL', 'REES', 'EMMERICH'.}

\item{w}{If the \code{wldf} does not supply a valid non-\code{NA} time slot,
it is possible to execute the function with the help of this optional
parameter. Otherwise \code{\link{getGaugingDataW}} or
\code{\link{getPegelonlineW}} provide gauging data internally.}

\item{uuid}{must be type \code{character} with a length of one. Permitted values are: '7cb7461b-3530-4c01-8978-7f676b8f71ed', '85d686f1-55b2-4d36-8dba-3207b50901a7', '70272185-b2b3-4178-96b8-43bea330dcae', '24440872-5bd2-4fb3-8554-907b49816c49', 'b04b739d-7ffa-41ee-9eb9-95cb1b4ef508', '16b9b4e7-be14-41fd-941e-6755c97276cc', '83bbaedb-5d81-4bc6-9f66-3bd700c99c1f', 'f3dc8f07-c2bb-4b92-b0b0-4e01a395a2c6', 'c093b557-4954-4f05-8f5c-6c6d7916c62d', '070b1eb4-3872-4e07-b2e5-e25fd9251b93', '1ce53a59-33b9-40dc-9b17-3cd2a2414607', 'ae93f2a5-612e-4514-b5fd-9c8aecdd73c7', 'e97116a4-7d30-4671-8ba1-cdce0a153d1d', '1edc5fa4-88af-47f5-95a4-0e77a06fe8b1', '094b96e5-caeb-46d3-a8ee-d44182add069', '939f82ec-15a9-49c8-8828-dc2f8a2d49e2', '90bcb315-f080-41a8-a0ac-6122331bb4cf', 'b8567c1e-8610-4c2b-a240-65e8a74919fa', 'ccccb57f-a2f9-4183-ae88-5710d3afaefd', 'e30f2e83-b80b-4b96-8f39-fa60317afcc7', '3adf88fd-fd7a-41d0-84f5-1143c98a6564', '133f0f6c-2ca1-4798-9360-5b5f417dd839', '13e91b77-90f3-41a5-a320-641748e9c311', 'de4cc1db-51cb-4b62-bee2-9750cbe4f5c4', 'f4c55f77-ab80-4e00-bed3-aa6631aba074', 'e32b0a28-8cd5-4053-bc86-fff9c6469106', 'cbf3cd49-91bd-49cc-8926-ccc6c0e7eca4', '48f2661f-f9cb-4093-9d57-da2418ed656e', '550e3885-a9d1-4e55-bd25-34228bd6d988', 'c80a4f21-528c-4771-98d7-10cd591699a4', 'ac507f42-1593-49ea-865f-10b2523617c7', '6e3ea719-48b1-408a-bc55-0986c1e94cd5', 'c233674f-259a-4304-b81f-dce1f415d85b', 'a26e57c9-1cb8-4fca-ba80-9e02abc81df8', '67d6e882-b60c-40d3-975c-a6d7a2b4e40a', '6aa1cd8e-e528-4bcb-ba8e-705b6dcb7da2', '33e0bce0-13df-4ffc-be9d-f1a79e795e1c', 'd9289367-c8aa-4b6a-b1ad-857fec94c6bb', 'b3492c68-8373-4769-9b29-22f66635a478', '44f7e955-c97d-45c8-9ed7-19406806fb4c', 'b02be240-1364-4c97-8bb6-675d7d842332', '6b774802-fcb5-49ae-8ecb-ecaf1a278b1c', 'b6c6d5c8-e2d5-4469-8dd8-fa972ef7eaea', '88e972e1-88a0-4eb9-847c-0925e5999a46', '2cb8ae5b-c5c9-4fa8-bac0-bb724f2754f4', '57090802-c51a-4d09-8340-b4453cd0e1f5', '844a620f-f3b8-4b6b-8e3c-783ae2aa232a', 'd28e7ed1-3317-41c5-bec6-725369ed1171', 'a37a9aa3-45e9-4d90-9df6-109f3a28a5af', '665be0fe-5e38-43f6-8b04-02a93bdbeeb4', '0309cd61-90c9-470e-99d4-2ee4fb2c5f84', '1d26e504-7f9e-480a-b52c-5932be6549ab', '550eb7e9-172e-48e4-ae1e-d1b761b42223', '2ff6379d-d168-4022-8da0-16846d45ef9b', 'd6dc44d1-63ac-4871-b175-60ac4040069a', '4c7d796a-39f2-4f26-97a9-3aad01713e29', '5735892a-ec65-4b29-97c5-50939aa9584e', 'b45359df-c020-4314-adb1-d1921db642da', '593647aa-9fea-43ec-a7d6-6476a76ae868', 'a6ee8177-107b-47dd-bcfd-30960ccc6e9c', '8f7e5f92-1153-4f93-acba-ca48670c8ca9', 'c0f51e35-d0e8-4318-afaf-c5fcbc29f4c1', 'f33c3cc9-dc4b-4b77-baa9-5a5f10704398', '2f025389-fac8-4557-94d3-7d0428878c86', '9598e4cb-0849-401e-bba0-689234b27644'.}

\item{shiny}{\code{logical} determing whether columns (\code{section},
\code{weight_x}, \code{weight_y}) relevant for the
\code{\link{plotShiny}()}-function are appended to the resulting
\linkS4class{WaterLevelDataFrame}.}
}
\value{
An object of class \linkS4class{WaterLevelDataFrame}.
}
\description{
This function computes a 1d water level according to the
  \href{https://www.bafg.de/DE/3_Beraet/4_Exp_oekologie/OekoModelle/oekomodelle_node.html#vt-sprg-3}{INFORM}
  flood duration method Flood1 (Flut1) and stores it as column \code{w} of an
  S4 object of type \linkS4class{WaterLevelDataFrame}. First the function
  obtains the reference water level MQ from \code{\link{df.flys}}. This
  reference water level is then shifted by the difference between measured
  water and the FLYS3 water level for MQ at the specified gauging station.
  Here it is provided mainly for historical reasons and more advanced 
  functions like \code{\link{waterLevel}} or 
  \code{\link{waterLevelPegelonline}} should be used.
}
\details{
This function computes a water level based on the reference water
  level MQ from \code{\link{df.flys}}. Since the function only shifts this
  single reference water level to make it fit to the measured water level,
  no interpolation is needed. Therefore the \code{shiny} columns have
  constant values of \code{section <- 1}, \code{weight_x <- 1} and
  \code{weight_y <- shift}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf1 <- waterLevelFlood1(wldf, "ROSSLAU")
wldf2 <- waterLevelFlood1(wldf, "DESSAU")

wldf1$w - wldf2$w

}
\references{
\insertRef{rosenzweig_inform_2011}{hyd1d}
  
  \insertRef{bundesanstalt_fur_gewasserkunde_flys_2016}{hyd1d}
}
