% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_pars.R
\name{update_pars}
\alias{update_pars}
\title{MCMC Third-Component Parameter Update Function for Hurdle Model Count Data
Regression}
\usage{
update_pars(y, hurd, dist, like.part, a, b, size, lam, mu, xi, sigma, lam.acc,
  mu.acc, xi.acc, sigma.acc, lam.tune, mu.tune, xi.tune, sigma.tune, g.x = F)
}
\arguments{
\item{y}{numeric response vector of observations within the bounds of the 
third component of the likelihood function, \eqn{y[y \ge hurd]}.}

\item{hurd}{numeric threshold for 'extreme' observations of two-hurdle models.}

\item{dist}{character specification of response distribution for the third 
component of the likelihood function.}

\item{like.part}{numeric vector of the current third-component likelihood values.}

\item{a}{shape parameter for gamma prior distributions.}

\item{b}{rate parameter for gamma prior distributions.}

\item{size}{size parameter for negative binomial likelihood distributions.}

\item{lam}{current value for the poisson likelihood lambda parameter.}

\item{mu}{current value for the negative binomial or log normal likelihood 
mu parameter.}

\item{xi}{current value for the generalized pareto likelihood xi parameter.}

\item{sigma}{current value for the generalized pareto likelihood sigma 
parameter.}

\item{lam.acc, mu.acc, xi.acc, sigma.acc}{current MCMC values for third-component 
parameter acceptance rates.}

\item{lam.tune, mu.tune, xi.tune, sigma.tune}{current MCMC tuning values for 
each third-component parameter.}

\item{g.x}{logical operator. \code{TRUE} if operating within the third component 
of the likelihood function (the likelihood of 'extreme' observations).}
}
\value{
A list of MCMC-updated likelihood estimator(s) for the third-component
parameter(s) and each parameter's MCMC acceptance ratio.
}
\description{
MCMC algorithm for updating the third-component likelihood 
parameters in hurdle model regression using \code{\link{hurdle}}.
}
\seealso{
\code{\link{hurdle}} \cr
\code{\link{dist_ll}}
}
\author{
Taylor Trippe <\email{ttrippe@luc.edu}> \cr
Earvin Balderama <\email{ebalderama@luc.edu}>
}
