% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle.R
\name{hurdle}
\alias{hurdle}
\title{Hurdle Model Count Data Regression}
\usage{
hurdle(y, x = NULL, hurd = Inf, dist = c("poisson", "nb", "lognormal"),
  dist.2 = c("gpd", "poisson", "lognormal", "nb"),
  control = hurdle_control(), iters = 1000, burn = 500, nthin = 1,
  plots = FALSE, progress.bar = TRUE)
}
\arguments{
\item{y}{numeric response vector.}

\item{x}{numeric predictor matrix.}

\item{hurd}{numeric threshold for 'extreme' observations of two-hurdle models. 
\code{Inf} for one-hurdle models.}

\item{dist}{character specification of response distribution.}

\item{dist.2}{character specification of response distribution for 
'extreme' observations of two-hurdle models.}

\item{control}{list of parameters for controlling the fitting process, 
specified by \code{\link{hurdle_control}}.}

\item{iters}{number of iterations for the Markov chain to run.}

\item{burn}{numeric burn-in length.}

\item{nthin}{numeric thinning rate.}

\item{plots}{logical operator. \code{TRUE} to output plots.}

\item{progress.bar}{logical operator. \code{TRUE} to print progress bar.}
}
\value{
\code{hurdle} returns a list which includes the items
\describe{
   \item{pD}{measure of model dimensionality \eqn{p_D} where 
   \eqn{p_D = \bar{D} - D(\bar{\theta}}) is the \eqn{"mean posterior deviance - 
   deviance of posterior means"}}
   \item{DIC}{Deviance Information Criterion where \eqn{DIC = \bar{D} - p_D}}
   \item{PPO}{Posterior Predictive Ordinate (PPO) measure of fit}
   \item{CPO}{Conditional Predictive Ordinate (CPO) measure of fit}
   \item{pars.means}{posterior mean(s) of third-component parameter(s) if 
   \code{hurd != Inf}}  
   \item{ll.means}{posterior means of the log-likelihood distributions of 
   all model components}
   \item{beta.means}{posterior means regression coefficients}
   \item{dev}{posterior deviation where \eqn{D = -2LogL}}
   \item{beta}{posterior distributions of regression coefficients}
   \item{pars}{posterior distribution(s) of third-component parameter(s) if 
   \code{hurd != Inf}}  
 }
}
\description{
\code{hurdle} is used to fit single or 
double-hurdle regression models to count data via Bayesian inference.
}
\details{
Setting \code{dist} and \code{dist.2} to be the same distribution creates a 
single \code{dist}-hurdle model, not a double-hurdle model. However, this 
is being considered in future package updates.
}
\examples{
#Generate some data:
p=0.5; q=0.25; lam=3;
mu=10; sigma=7; xi=0.75;
n=200

set.seed(2016)
y <- rbinom(n,1,p)
nz <- sum(1-y)
extremes <- rbinom(sum(y),1,q)
ne <- sum(extremes)
nt <- n-nz-ne
yt <- sample(mu-1,nt,replace=TRUE,prob=dpois(1:(mu-1),3)/(ppois(mu-1,lam)-ppois(0,lam)))
yz <- round(rgpd(nz,mu,sigma,xi))
y[y==1] <- c(yt,yz)
g <- hurdle(y)












}
\author{
Taylor Trippe <\email{ttrippe@luc.edu}> \cr
Earvin Balderama <\email{ebalderama@luc.edu}>
}
