% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powercalc.R
\name{calcvar}
\alias{calcvar}
\title{Variance of estimator}
\usage{
calcvar(lambda, eigendec, n, weights = 1)
}
\arguments{
\item{lambda}{shrinkage parameter}

\item{eigendec}{eigenvalue decomposition of (p x p) correlation matrix
\code{R}}

\item{n}{sample size}

\item{weights}{vector (LEN p) of SNP-specific weights or scalar if weights
are equal for all SNPs; default value 1}
}
\value{
\describe{
  \item{\code{df}}{residual degrees of freedom}
  \item{\code{var.beta}}{vector (LEN p) of variance of estimator beta up to a
    constant (i.e. residual variance / n)}
}
}
\description{
Calculation of variance of estimator and residual degrees of
  freedom
}
\details{
The variance of estimator beta (regression coefficient of SNP-BLUP
  approach) and the residual degrees of freedom are calculated based on the
  eigenvalue decomposition of correlation matrix \code{R}
}
\examples{
  ### correlation matrix (should depend on sire haplotypes)
  R <- AR1(100, rho = 0.1)
  eigendec <- eigen(R)
  out <- calcvar(1200, eigendec, 100)
}
