% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothIndex.R
\name{smoothIndex}
\alias{smoothIndex}
\title{Smooth an index}
\usage{
smoothIndex(index_obj, order = 3, in_place = FALSE, ...)
}
\arguments{
\item{index_obj}{Index to be smoothed}

\item{order}{default = 3; Number of nearby period to smooth with, multiple means
multiple iterations}

\item{in_place}{default = FALSE; adds smoothed index to the `hpiindex` object}

\item{...}{Additional Arguments}
}
\value{
a `ts`` and 'smooth_index` object with smoothed index
}
\description{
Smooths an existing hpiindex object
}
\section{Further Details}{

Leaving order blank default to a moving average with order 3.
}

\examples{

 # Load data
 data(ex_sales)

 # Create index with raw transaction data
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Create Smooth index
 sm_index <- smoothIndex(index_obj = rt_index,
                         order = 3,
                         in_place = FALSE)

 # Create Smooth index (in place)
 sm_index <- smoothIndex(index_obj = rt_index,
                         order = 3,
                         in_place = TRUE)

}
