% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createSeries.R
\name{createSeries}
\alias{createSeries}
\title{Create a series of indexes}
\usage{
createSeries(hpi_obj, train_period = 12, max_period = NULL, ...)
}
\arguments{
\item{hpi_obj}{Object of class 'hpi'}

\item{train_period}{default = 12; Number of periods to use as purely training before creating indexes}

\item{max_period}{default = NULL; Maximum number of periods to create the index up to}

\item{...}{Additional Arguments}
}
\value{
An `serieshpi` object -- a list of `hpi` objects.
}
\description{
Generate a series of progressive indexes
}
\section{Further Details}{

`train_period` Represents the shortest index that you will create. For certain
approaches, such as a repeat transaction model, indexes shorter than 10 will likely
be highly unstable.

If `max_period`` is left NULL, then it will forecast up to the end of the data.
}

\examples{

  # Load example sales
 data(ex_sales)

 # Create Index
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Create Series (Suppressing messages do to small sample size of this example)
  suppressMessages(
    hpi_series <- createSeries(hpi_obj = rt_index,
                               train_period = 12))

}
