% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbagl_schedule.R
\name{nbagl_schedule}
\alias{nbagl_schedule}
\title{\strong{Get G League Schedule from NBA API}}
\usage{
nbagl_schedule(season = most_recent_nba_season() - 1, ...)
}
\arguments{
\item{season}{Season - 4 digit, i.e. 2021}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a data frame of the G League Season Schedule\tabular{ll}{
   col_name \tab types \cr
   mon \tab character \cr
   gid \tab character \cr
   gcode \tab character \cr
   seri \tab character \cr
   is \tab integer \cr
   gdte \tab character \cr
   htm \tab character \cr
   vtm \tab character \cr
   etm \tab character \cr
   an \tab character \cr
   ac \tab character \cr
   as \tab character \cr
   st \tab character \cr
   stt \tab character \cr
   gdtutc \tab character \cr
   utctm \tab character \cr
   ppdst \tab character \cr
   seq \tab integer \cr
   bd_b \tab list \cr
   v_tid \tab integer \cr
   v_re \tab character \cr
   v_ta \tab character \cr
   v_tn \tab character \cr
   v_tc \tab character \cr
   v_s \tab character \cr
   h_tid \tab integer \cr
   h_re \tab character \cr
   h_ta \tab character \cr
   h_tn \tab character \cr
   h_tc \tab character \cr
   h_s \tab character \cr
   ptsls_pl \tab list \cr
}
}
\description{
Scrapes the NBA Data API for G League Schedule for a Given Season
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nbagl_schedule(season = most_recent_nba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA G-League Functions: 
\code{\link{nbagl_pbp}()},
\code{\link{nbagl_players}()},
\code{\link{nbagl_standings}()}
}
\author{
Billy Fryer
}
\concept{NBA G-League Functions}
