% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nba_stats_team.R
\name{nba_teamestimatedmetrics}
\alias{nba_teamestimatedmetrics}
\title{\strong{Get NBA Stats API Team Estimated Metrics}}
\usage{
nba_teamestimatedmetrics(
  league_id = "00",
  season = year_to_season(most_recent_nba_season() - 1),
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WNBA, '20': G-League}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: TeamEstimatedMetrics

\strong{TeamEstimatedMetrics}\tabular{ll}{
   col_name \tab types \cr
   TEAM_NAME \tab character \cr
   TEAM_ID \tab character \cr
   GP \tab character \cr
   W \tab character \cr
   L \tab character \cr
   W_PCT \tab character \cr
   MIN \tab character \cr
   E_OFF_RATING \tab character \cr
   E_DEF_RATING \tab character \cr
   E_NET_RATING \tab character \cr
   E_PACE \tab character \cr
   E_AST_RATIO \tab character \cr
   E_OREB_PCT \tab character \cr
   E_DREB_PCT \tab character \cr
   E_REB_PCT \tab character \cr
   E_TM_TOV_PCT \tab character \cr
   GP_RANK \tab character \cr
   W_RANK \tab character \cr
   L_RANK \tab character \cr
   W_PCT_RANK \tab character \cr
   MIN_RANK \tab character \cr
   E_OFF_RATING_RANK \tab character \cr
   E_DEF_RATING_RANK \tab character \cr
   E_NET_RATING_RANK \tab character \cr
   E_AST_RATIO_RANK \tab character \cr
   E_OREB_PCT_RANK \tab character \cr
   E_DREB_PCT_RANK \tab character \cr
   E_REB_PCT_RANK \tab character \cr
   E_TM_TOV_PCT_RANK \tab character \cr
   E_PACE_RANK \tab character \cr
}
}
\description{
\strong{Get NBA Stats API Team Estimated Metrics}

\strong{Get NBA Stats API Team Estimated Metrics}
}
\details{
\href{https://www.nba.com/stats/teams/estimated-advanced}{Team Estimated Metrics}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ nba_teamestimatedmetrics()
}\if{html}{\out{</div>}}
}
\seealso{
Other NBA Team Functions: 
\code{\link{nba_leaguedashteamstats}()},
\code{\link{nba_teamdashboardbyclutch}()},
\code{\link{nba_teamdashboardbygamesplits}()},
\code{\link{nba_teamdashboardbygeneralsplits}()},
\code{\link{nba_teamdashboardbylastngames}()},
\code{\link{nba_teamdashboardbyopponent}()},
\code{\link{nba_teamdashboardbyshootingsplits}()},
\code{\link{nba_teamdashboardbyteamperformance}()},
\code{\link{nba_teamdashboardbyyearoveryear}()},
\code{\link{nba_teamdashlineups}()},
\code{\link{nba_teamdashptpass}()},
\code{\link{nba_teamdashptreb}()},
\code{\link{nba_teamdashptshots}()},
\code{\link{nba_teamdetails}()},
\code{\link{nba_teamgamelogs}()},
\code{\link{nba_teamgamelog}()},
\code{\link{nba_teamgamestreakfinder}()},
\code{\link{nba_teamhistoricalleaders}()},
\code{\link{nba_teaminfocommon}()},
\code{\link{nba_teamplayerdashboard}()},
\code{\link{nba_teamplayeronoffdetails}()},
\code{\link{nba_teamplayeronoffsummary}()},
\code{\link{nba_teams}()},
\code{\link{nba_teamvsplayer}()},
\code{\link{nba_teamyearbyyearstats}()}
}
\author{
Saiem Gilani
}
\concept{NBA Team Functions}
