% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kp_team_tables.R
\name{kp_team_depth_chart}
\alias{kp_team_depth_chart}
\title{\strong{Get Depth Chart Last 5 Games from Team Page}}
\usage{
kp_team_depth_chart(team, year = 2021)
}
\arguments{
\item{team}{Team filter to select.}

\item{year}{Year of data to pull}
}
\value{
A data frame with the following columns:\tabular{ll}{
   col_name \tab types \cr
   pg_number \tab numeric \cr
   pg_player_first_name \tab character \cr
   pg_player_last_name \tab character \cr
   pg_hgt \tab character \cr
   pg_wgt \tab numeric \cr
   pg_yr \tab character \cr
   pg_min_pct \tab numeric \cr
   sg_number \tab numeric \cr
   sg_player_first_name \tab character \cr
   sg_player_last_name \tab character \cr
   sg_hgt \tab character \cr
   sg_wgt \tab numeric \cr
   sg_yr \tab character \cr
   sg_min_pct \tab numeric \cr
   sf_number \tab numeric \cr
   sf_player_first_name \tab character \cr
   sf_player_last_name \tab character \cr
   sf_hgt \tab character \cr
   sf_wgt \tab numeric \cr
   sf_yr \tab character \cr
   sf_min_pct \tab numeric \cr
   pf_number \tab numeric \cr
   pf_player_first_name \tab character \cr
   pf_player_last_name \tab character \cr
   pf_hgt \tab character \cr
   pf_wgt \tab numeric \cr
   pf_yr \tab character \cr
   pf_min_pct \tab numeric \cr
   c_number \tab numeric \cr
   c_player_first_name \tab character \cr
   c_player_last_name \tab character \cr
   c_hgt \tab character \cr
   c_wgt \tab numeric \cr
   c_yr \tab character \cr
   c_min_pct \tab numeric \cr
   team \tab character \cr
   year \tab numeric \cr
}
}
\description{
\strong{Get Depth Chart Last 5 Games from Team Page}
}
\examples{
  \donttest{
    try(kp_team_depth_chart(team = 'Florida St.', year= 2021))
  }


}
\seealso{
Other KenPom Team Functions: 
\code{\link{kp_gameplan}()},
\code{\link{kp_minutes_matrix}()},
\code{\link{kp_opptracker}()},
\code{\link{kp_player_career}()},
\code{\link{kp_team_lineups}()},
\code{\link{kp_team_player_stats}()},
\code{\link{kp_team_players}()},
\code{\link{kp_team_schedule}()}
}
\concept{KenPom Team Functions}
\keyword{Chart}
\keyword{Depth}
