% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paillier.R
\docType{class}
\name{PaillierKeyPair}
\alias{PaillierKeyPair}
\title{Construct a Paillier public and private key pair given a fixed number of bits}
\format{
An \code{\link[R6:R6Class]{R6::R6Class()}} generator object
}
\description{
Construct a Paillier public and private key pair given a fixed number of bits

Construct a Paillier public and private key pair given a fixed number of bits
}
\section{Methods}{

\describe{
\item{\code{PaillierKeyPair$getPrivateKey()}}{Return the private key}
}
}

\examples{
keys <- PaillierKeyPair$new(1024)
keys$pubkey
keys$getPrivateKey()

}
\seealso{
\code{\link[=PaillierPublicKey]{PaillierPublicKey()}} and \code{\link[=PaillierPrivateKey]{PaillierPrivateKey()}}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pubkey}}{the public key}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PaillierKeyPair-new}{\code{PaillierKeyPair$new()}}
\item \href{#method-PaillierKeyPair-getPrivateKey}{\code{PaillierKeyPair$getPrivateKey()}}
\item \href{#method-PaillierKeyPair-clone}{\code{PaillierKeyPair$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierKeyPair-new"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierKeyPair-new}{}}}
\subsection{Method \code{new()}}{
Create a new public private key pair with specified number of modulus bits
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierKeyPair$new(modulusBits)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{modulusBits}}{the number of bits to use}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{PaillierKeyPair} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierKeyPair-getPrivateKey"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierKeyPair-getPrivateKey}{}}}
\subsection{Method \code{getPrivateKey()}}{
Return the private key
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierKeyPair$getPrivateKey()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the private key
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PaillierKeyPair-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PaillierKeyPair-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PaillierKeyPair$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
