% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlighter.R
\name{highlighter}
\alias{highlighter}
\title{Highlighter}
\usage{
highlighter(
  code,
  language = "r",
  theme = "default",
  plugins = NULL,
  width = "100\%",
  height = "auto",
  elementId = NULL
)
}
\arguments{
\item{code}{The code to be highlighted}

\item{language}{The programming language chosen to be highlighted}

\item{theme}{A character. Indicating which theme will be used}

\item{plugins}{Optional. A list of plugins to be used}

\item{width}{Optional. The width to be used by the widget}

\item{height}{Optional. The height to be used by the widget}

\item{elementId}{Optional. The DOM element id to be used by the widget}
}
\value{
An object of class \code{highlighter}
}
\description{
Highlights code
}
\examples{
# Highlight R code
if (interactive()) {
  highlighter("print('Hello, world!')", language = "r")
}
}
\seealso{
\code{\link[=get_available_languages]{get_available_languages()}} for available languages,
\code{\link[=get_available_themes]{get_available_themes()}} for available themes
}
