% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppboot.R
\name{boot.ppbetas}
\alias{boot.ppbetas}
\title{Estimates bootstrap confidence intervals for pairwise betas FST estimates}
\usage{
boot.ppbetas(dat=dat,nboot=100,quant=c(0.025,0.975),diploid=TRUE,digits=4)
}
\arguments{
\item{dat}{A data frame containing population of origin as the first column 
and multi-locus genotypes in following columns}

\item{nboot}{the number of bootstrap samples to draw}

\item{quant}{the limit of the confidence intervals}

\item{diploid}{whether the data is from a diploid (default) or haploid organism}

\item{digits}{how many digits to print out}
}
\value{
a matrix with upper limit of the bootstrap CI
above the diagonal and lower limit below the diagonal
}
\description{
Estimates bootstrap confidence intervals for pairwise betas FST estimates.
}
\examples{
\dontrun{
data(gtrunchier)
boot.ppbetas(gtrunchier[,-2])
}
}
\seealso{
\link{betas} \link{pairwise.betas}
}
