% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_helpers.R
\name{cell_to_sf}
\alias{cell_to_sf}
\title{Convert cell IDs to sf polygons}
\usage{
cell_to_sf(cell_id = NULL, grid, wrap_dateline = TRUE)
}
\arguments{
\item{cell_id}{Numeric vector of cell IDs. If NULL and x is HexData,
uses cells from x.}

\item{grid}{A HexGridInfo or HexData object. If HexData and cell_id is NULL,
polygons are generated for all cells in the data.}

\item{wrap_dateline}{Logical. If TRUE (default), calls
\code{sf::st_wrap_dateline()} to split antimeridian-crossing polygons.
Set to FALSE for orthographic/globe projections where wrapping creates gaps.}
}
\value{
sf object with cell_id and geometry columns
}
\description{
Creates sf polygon geometries for hexagonal grid cells.
}
\details{
When called with a HexData object and no cell_id argument, this function
generates polygons for all unique cells in the data, which is useful for
plotting.
}
\examples{
# From grid specification
grid <- hex_grid(area_km2 = 1000)
cells <- lonlat_to_cell(c(0, 10, 20), c(45, 50, 55), grid)
polys <- cell_to_sf(cells, grid)

# From HexData (all cells)
df <- data.frame(lon = c(0, 10, 20), lat = c(45, 50, 55))
result <- hexify(df, lon = "lon", lat = "lat", area_km2 = 1000)
polys <- cell_to_sf(grid = result)
}
\seealso{
\code{\link{hex_grid}} for grid specifications,
\code{\link{as_sf}} for converting HexData to sf
}
