% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_helpers.R
\name{cell_area}
\alias{cell_area}
\title{Compute per-cell area in km²}
\usage{
cell_area(cell_id = NULL, grid)
}
\arguments{
\item{cell_id}{Cell IDs to compute area for. For ISEA grids, these are
numeric; for H3 grids, character strings. When \code{grid} is a HexData
object and \code{cell_id} is \code{NULL}, all cell IDs from the data are
used.}

\item{grid}{A HexGridInfo or HexData object.}
}
\value{
Named numeric vector of areas in km², one per \code{cell_id}.
}
\description{
Returns the area of each cell in square kilometers. For ISEA grids, all
cells have the same area (equal-area property). For H3 grids, each cell
has a different geodesic area depending on its location.
}
\details{
For ISEA grids the area is constant across all cells and is read directly
from the grid specification.

For H3 grids the area varies by latitude. This function computes geodesic
area via \code{sf::st_area()} on H3 cell polygons, with results cached in a
session-scoped environment so repeated calls for the same cells are fast.
}
\examples{
# ISEA: constant area
grid <- hex_grid(area_km2 = 1000)
cells <- lonlat_to_cell(c(0, 10, 20), c(45, 50, 55), grid)
cell_area(cells, grid)

# H3: area varies by location
\donttest{
h3 <- hex_grid(resolution = 5, type = "h3")
h3_cells <- lonlat_to_cell(c(0, 0), c(0, 80), h3)
cell_area(h3_cells, h3)  # equator vs polar — different areas
}
}
\seealso{
\code{\link{hex_grid}} for grid specifications,
\code{\link{h3_crosswalk}} for ISEA/H3 interoperability
}
