% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{predictProbInternal}
\alias{predictProbInternal}
\title{Generic function to predict the probability row 1 has a higher criterion.}
\usage{
predictProbInternal(object, row1, row2)
}
\arguments{
\item{object}{The object that implements predictPair, e.g. a ttb model.}

\item{row1}{The first row of cues (object$cols_to_fit columns), as a
one-row matrix.}

\item{row2}{The second row of cues.}
}
\value{
A value from 0 to 1, representing the probability that row1's
  criterion is greater than row2's criterion.
}
\description{
Do not call this directly (which is why it is called "internal").
Instead, call predictPairProb.  Heuristics implement this function in order
to be callable with predictPairProb.
}
\details{
Most heuristics have not implemented this.  Also, the output cannot (and
should not) be assessed with categorical measures like percent correct.
}
\keyword{internal}
