% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hero.R, R/hero.prepared_array.R,
%   R/hero.prepared_list.R, R/hero.prepared_matrix.R, R/hero.prepared_numeric.R,
%   R/hero.prepared_sequential.R, R/hero.prepared_starray.R,
%   R/hero.prepared_sts.R
\name{hero}
\alias{hero}
\alias{hero.prepared_array}
\alias{hero.prepared_list}
\alias{hero.prepared_matrix}
\alias{hero.prepared_numeric}
\alias{hero.prepared_sequential}
\alias{hero.prepared_starray}
\alias{hero.prepared_sts}
\title{Construct a hero sandwich smoother}
\usage{
hero(x, ...)

\method{hero}{prepared_array}(x, ...)

\method{hero}{prepared_list}(x, ..., fitted = FALSE)

\method{hero}{prepared_matrix}(x, ...)

\method{hero}{prepared_numeric}(x, ...)

\method{hero}{prepared_sequential}(
  x,
  ...,
  export_list,
  export_fun = base::saveRDS,
  package = "base",
  call_args = list()
)

\method{hero}{prepared_starray}(x, ...)

\method{hero}{prepared_sts}(x, ...)
}
\arguments{
\item{x}{Data prepared via the \code{\link{prepare}}
function.}

\item{...}{Mostly not implemented.  \code{hero.prepared_list} takes
the \code{fitted} argument, specifying whether the \code{fitted}
values should be returned.}

\item{fitted}{A logical value indicating whether the fitted values should be
computed. The default is \code{FALSE}.}

\item{export_list}{A vector or list whose elements tell \code{export_fun}
what files to export. The length must match the number of observations,
i.e., the number of elements in \code{x$Ytilde}}

\item{export_fun}{A function that will write the results for each observation
to file using the names in \code{export_list}. Must only have the arguments
\code{object}, which is what will be saved and computed internally, and
\code{file}, which is the name of the file that will be saved. \code{file}
will be one of the elements of \code{export_list}.}

\item{package}{A character string indicating the approach to use for the
computations. The choices are \code{"base"}, \code{"parallel"},
\code{"pbapply"}, \code{"future.apply"}, or \code{"Rmpi"}. The default is
\code{"base"}. If \code{package == "base"}, then \code{\link[base]{mapply}}
is used. If \code{package == "parallel"}, then
\code{\link[parallel]{mcmapply}} is used. If \code{package == "pbapply"},
then \code{\link[pbapply]{pblapply}} is used. If code{package ==
"future.apply"}, then \code{\link[future.apply]{future_mapply}} is used. If
code{package == "Rmpi"}, then \code{\link[Rmpi]{mpi.applyLB}} is used.}

\item{call_args}{A named list providing relevant arguments to
\code{\link[parallel]{mcmapply}}, \code{\link[pbapply]{pblapply}},
\code{\link[future.apply]{future_mapply}}, or
\code{\link[Rmpi]{mpi.applyLB}}, depending on the \code{package} choice.}
}
\value{
A \code{hero} object with the smoothed data
  (\code{fitted}), the estimated coefficients for the
  basis functions (\code{coefficients}), and the
  locations of the original data (\code{x}).
}
\description{
\code{hero} constructs a hero sandwich smoother based off
off a prepared data object coming from the
\code{\link{prepare}} function.  \cr
Subclasses are added (e.g., \code{hero_numeric},
\code{hero_matrix}, \code{hero_array}, etc.) are added to
the returned object for plotting purposes.
\cr
A list is returned (and the data locations are not) for
\code{hero.prepared_list}.  Each element of the list
contains the coefficients and fitted values (if \code{fitted} is
TRUE) for the respective data observation.
}
\examples{
# create b-splines
x1 = bspline(nbasis = 10)
x2 = bspline(nbasis = 12)

# observed data locations
evalarg1 = seq(0, 1, len = 60)
evalarg2 = seq(0, 1, len = 80)

# construct "true" data
mu = matrix(0, nrow = 60, ncol = 80)
for(i in seq_len(60)) {
   for(j in seq_len(80)) {
      mu[i, j] =  sin(2*pi*(evalarg1[i]-.5)^3)*cos(4*pi*evalarg2[j])
   }
}
# construct noisy data
data = mu + rnorm(60 * 80)

obj = prepare(data, list(evalarg1, evalarg2), list(x1, x2))
obj = enhance(obj)
sandmod = hero(obj)
plot(sandmod)
}
\references{
Xiao, L. , Li, Y. and Ruppert, D. (2013),
  Fast bivariate P-splines: the sandwich smoother. J. R.
  Stat. Soc. B, 75: 577-599. <doi:10.1111/rssb.12007>

  French, Joshua P., and Piotr S. Kokoszka. "A sandwich
  smoother for spatio-temporal functional data." Spatial
  Statistics 42 (2021): 100413.
}
\author{
Joshua French.
}
