% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\name{documentFun}
\alias{documentFun}
\title{Internal function used for documenting other functions}
\usage{
documentFun(
  title = NULL,
  xLab = "x",
  yLab = "y",
  legendTitle = "Legend",
  legendLabs = c("a", "b"),
  legendPos = "right",
  palette = "Spectral",
  viridisPal = "turbo",
  labeledPoints = NULL,
  labelType = "free",
  labelOutside = TRUE,
  labelSize = 2.5,
  labelColor = "black",
  labelRepulsion = 1,
  labelPull = 1,
  maxOverlaps = 50,
  boxPadding = 0.2,
  labelPadding = 0.1,
  labelSegWidth = 0.4,
  pointSize = 0.8,
  pointShape = 1,
  legendTitleSize = 10,
  legendTextSize = 10,
  axisTextSize = 12,
  axisTitleSize = 12,
  xAngle = 45,
  vJust = 0.6,
  margins = margin(0, -10, -10, -10),
  theme = "linedraw",
  pvalOffset = 1.00000023069254e-317,
  ...
)
}
\arguments{
\item{title}{Plot title.}

\item{xLab}{x axis label.}

\item{yLab}{y axis label.}

\item{legendTitle}{Legend title.}

\item{legendLabs}{Legend labels.}

\item{legendPos}{Legend position.}

\item{palette}{Color palette.}

\item{viridisPal}{Viridis palette.}

\item{labeledPoints}{Point labels to be displayed on the plot.}

\item{labelType}{Whether to draw a box around labels (option 'boxed') or not
(option 'free'). Default is 'free'.}

\item{labelSize}{Label size.}

\item{labelColor}{Label color.}

\item{labelRepulsion}{Repulsion strength between labels.}

\item{labelPull}{Attraction strength between a text label
and its data point.}

\item{maxOverlaps}{Maximum number of allowed overlaps.}

\item{boxPadding}{Amount of padding around box.}

\item{labelPadding}{Amount of padding around label.}

\item{labelSegWidth}{Thickness of segment connecting label to point.}

\item{pointSize}{Point size.}

\item{pointShape}{Point shape.}

\item{legendTitleSize}{Legend title size.}

\item{legendTextSize}{Legend text size.}

\item{axisTextSize}{Axis text size.}

\item{axisTitleSize}{Axis title size.}

\item{xAngle}{Angle of x axis text.}

\item{vJust}{Vertical justification in [0, 1].}

\item{margins}{Plot margins. Must be a vector of size 4 listing the desired
top, right, bottom and left margin, in that order.}

\item{theme}{Plot theme.}

\item{pvalOffset}{Offset added to p-values to avoid infinite values when
taking logarithms.}

\item{...}{Additional arguments passed to \code{centerTitle}.}
}
\value{
\code{NULL}. This function is only used internally for
documentation.
}
\description{
This function is used internally to help document other functions.
}
\keyword{internal}
